/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.summaryrow;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.IDpiConverter;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommand;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiRowResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEvent;
import org.eclipse.nebula.widgets.nattable.summaryrow.DefaultSummaryRowConfiguration;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.summaryrow.command.CalculateSummaryRowValuesCommand;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.nebula.widgets.nattable.util.CalculatedValueCache;
import org.eclipse.nebula.widgets.nattable.util.ICalculatedValueCache;
import org.eclipse.nebula.widgets.nattable.util.ICalculator;

public class SummaryRowLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    public static final String DEFAULT_SUMMARY_ROW_CONFIG_LABEL = "SummaryRow";
    public static final String DEFAULT_SUMMARY_COLUMN_CONFIG_LABEL_PREFIX = "SummaryColumn_";
    private final IConfigRegistry configRegistry;
    private int summaryRowHeight = 20;
    private ICalculatedValueCache valueCache;
    private IDpiConverter dpiConverter;
    private boolean standalone = false;

    public SummaryRowLayer(IUniqueIndexLayer underlyingDataLayer, IConfigRegistry configRegistry) {
        this(underlyingDataLayer, configRegistry, true, true);
    }

    public SummaryRowLayer(IUniqueIndexLayer underlyingDataLayer, IConfigRegistry configRegistry, boolean autoConfigure) {
        this(underlyingDataLayer, configRegistry, true, autoConfigure);
    }

    public SummaryRowLayer(IUniqueIndexLayer underlyingDataLayer, IConfigRegistry configRegistry, boolean smoothUpdates, boolean autoConfigure) {
        super(underlyingDataLayer);
        this.configRegistry = configRegistry;
        this.valueCache = new CalculatedValueCache(this, true, false, smoothUpdates);
        if (autoConfigure) {
            this.addConfiguration(new DefaultSummaryRowConfiguration());
        }
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return this.calculateNewSummaryValue(columnPosition, true);
        }
        return super.getDataValueByPosition(columnPosition, rowPosition);
    }

    private Object calculateNewSummaryValue(final int columnPosition, boolean calculateInBackground) {
        return this.valueCache.getCalculatedValue(columnPosition, this.getSummaryRowPosition(), calculateInBackground, new ICalculator(){

            @Override
            public Object executeCalculation() {
                LabelStack labelStack = SummaryRowLayer.this.getConfigLabelsByPositionWithoutTransformation(columnPosition, SummaryRowLayer.this.getSummaryRowPosition());
                String[] configLabels = labelStack.getLabels().toArray(ArrayUtil.STRING_TYPE_ARRAY);
                ISummaryProvider summaryProvider = SummaryRowLayer.this.configRegistry.getConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, "NORMAL", configLabels);
                if (summaryProvider == ISummaryProvider.NONE || summaryProvider == null) {
                    return null;
                }
                return summaryProvider.summarize(columnPosition);
            }
        });
    }

    public boolean isSummaryRowPosition(int rowPosition) {
        return rowPosition == this.getSummaryRowPosition();
    }

    public int getSummaryRowPosition() {
        return this.getRowCount() - 1;
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof RowResizeCommand && command.convertToTargetLayer(this)) {
            RowResizeCommand rowResizeCommand = (RowResizeCommand)command;
            if (this.isSummaryRowPosition(rowResizeCommand.getRowPosition())) {
                this.summaryRowHeight = rowResizeCommand.downScaleValue() && this.dpiConverter != null ? this.dpiConverter.convertDpiToPixel(rowResizeCommand.getNewHeight()) : rowResizeCommand.getNewHeight();
                this.fireLayerEvent(new RowResizeEvent((ILayer)this, this.getSummaryRowPosition()));
                return true;
            }
        } else if (command instanceof MultiRowResizeCommand && command.convertToTargetLayer(this)) {
            MultiRowResizeCommand rowResizeCommand = (MultiRowResizeCommand)command;
            for (int row : rowResizeCommand.getRowPositions()) {
                if (!this.isSummaryRowPosition(row)) continue;
                this.summaryRowHeight = rowResizeCommand.downScaleValue() && this.dpiConverter != null ? this.dpiConverter.convertDpiToPixel(rowResizeCommand.getRowHeight(row)) : rowResizeCommand.getRowHeight(row);
                this.fireLayerEvent(new RowResizeEvent((ILayer)this, this.getSummaryRowPosition()));
            }
        } else if (command instanceof CalculateSummaryRowValuesCommand) {
            int i = 0;
            while (i < this.getColumnCount()) {
                this.calculateNewSummaryValue(i, false);
                ++i;
            }
        } else if (command instanceof DisposeResourcesCommand) {
            this.valueCache.dispose();
        } else if (command instanceof ConfigureScalingCommand) {
            this.dpiConverter = ((ConfigureScalingCommand)command).getVerticalDpiConverter();
        }
        return super.doCommand(command);
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IVisualChangeEvent) {
            this.clearCache();
        }
        super.handleLayerEvent(event);
    }

    public void clearCache() {
        this.valueCache.clearCache();
    }

    public void killCache() {
        this.valueCache.killCache();
    }

    protected LabelStack getConfigLabelsByPositionWithoutTransformation(int columnPosition, int rowPosition) {
        return this.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            LabelStack labelStack = new LabelStack(new String[0]);
            if (this.getConfigLabelAccumulator() != null) {
                this.getConfigLabelAccumulator().accumulateConfigLabels(labelStack, columnPosition, rowPosition);
            }
            labelStack.addLabelOnTop(DEFAULT_SUMMARY_ROW_CONFIG_LABEL);
            labelStack.addLabelOnTop(DEFAULT_SUMMARY_COLUMN_CONFIG_LABEL_PREFIX + columnPosition);
            return labelStack;
        }
        return super.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return new LayerCell(this, columnPosition, rowPosition);
        }
        return super.getCellByPosition(columnPosition, rowPosition);
    }

    @Override
    public int getHeight() {
        if (this.standalone) {
            return this.getRowHeightByPosition(this.getSummaryRowPosition());
        }
        return super.getHeight() + this.getRowHeightByPosition(this.getSummaryRowPosition());
    }

    @Override
    public int getPreferredHeight() {
        if (this.standalone) {
            return this.getRowHeightByPosition(this.getSummaryRowPosition());
        }
        return super.getPreferredHeight() + this.getRowHeightByPosition(this.getSummaryRowPosition());
    }

    @Override
    public int getRowCount() {
        if (this.standalone) {
            return 1;
        }
        return super.getRowCount() + 1;
    }

    @Override
    public int getPreferredRowCount() {
        return this.getRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return rowPosition;
        }
        return super.getRowIndexByPosition(rowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY(this, y);
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            if (this.dpiConverter != null) {
                return this.dpiConverter.convertPixelToDpi(this.summaryRowHeight);
            }
            return this.summaryRowHeight;
        }
        return super.getRowHeightByPosition(rowPosition);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return rowIndex;
        }
        return -1;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            return columnIndex;
        }
        return -1;
    }

    public boolean isStandalone() {
        return this.standalone;
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    public ICalculatedValueCache getValueCache() {
        return this.valueCache;
    }

    public void setValueCache(ICalculatedValueCache valueCache) {
        this.valueCache = valueCache;
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByColumnPosition(int columnPosition) {
        return this.standalone ? null : super.getUnderlyingLayersByColumnPosition(columnPosition);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByRowPosition(int rowPosition) {
        return this.standalone ? null : super.getUnderlyingLayersByRowPosition(rowPosition);
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(int columnPosition, int rowPosition) {
        return this.standalone ? null : super.getUnderlyingLayerByPosition(columnPosition, rowPosition);
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> labels = super.getProvidedLabels();
        labels.add(DEFAULT_SUMMARY_ROW_CONFIG_LABEL);
        int i = 0;
        while (i < this.getColumnCount()) {
            labels.add(DEFAULT_SUMMARY_COLUMN_CONFIG_LABEL_PREFIX + i);
            ++i;
        }
        return labels;
    }
}

