/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class RowReorderEvent
extends RowStructuralChangeEvent {
    private ILayer beforeLayer;
    private Collection<Range> beforeFromRowPositionRanges;
    private Collection<Integer> beforeFromRowIndexes;
    private int beforeToRowPosition;
    private int beforeToRowIndex;
    private boolean reorderToTopEdge;

    @Deprecated
    public RowReorderEvent(ILayer layer, int beforeFromRowPosition, int beforeToRowPosition, boolean reorderToTopEdge) {
        this(layer, beforeFromRowPosition, beforeFromRowPosition, beforeToRowPosition, beforeToRowPosition, reorderToTopEdge);
    }

    public RowReorderEvent(ILayer layer, int beforeFromRowPosition, int beforeFromRowIndex, int beforeToRowPosition, int beforeToRowIndex, boolean reorderToTopEdge) {
        this(layer, Arrays.asList(beforeFromRowPosition), Arrays.asList(beforeFromRowIndex), beforeToRowPosition, beforeToRowIndex, reorderToTopEdge);
    }

    @Deprecated
    public RowReorderEvent(ILayer layer, List<Integer> beforeFromRowPositions, int beforeToRowPosition, boolean reorderToTopEdge) {
        this(layer, beforeFromRowPositions, beforeFromRowPositions, beforeToRowPosition, beforeToRowPosition, reorderToTopEdge);
    }

    public RowReorderEvent(ILayer layer, List<Integer> beforeFromRowPositions, List<Integer> beforeFromRowIndexes, int beforeToRowPosition, int beforeToRowIndex, boolean reorderToTopEdge) {
        super(layer, new Range[0]);
        this.beforeLayer = layer;
        this.beforeFromRowPositionRanges = PositionUtil.getRanges(beforeFromRowPositions);
        this.beforeFromRowIndexes = beforeFromRowIndexes;
        this.beforeToRowPosition = beforeToRowPosition;
        this.beforeToRowIndex = beforeToRowIndex;
        this.reorderToTopEdge = reorderToTopEdge;
        ArrayList<Integer> allColumnPositions = new ArrayList<Integer>(beforeFromRowPositions);
        allColumnPositions.add(beforeToRowPosition);
        this.setRowPositionRanges(PositionUtil.getRanges(allColumnPositions));
    }

    public RowReorderEvent(RowReorderEvent event) {
        super(event);
        this.beforeLayer = event.beforeLayer;
        this.beforeFromRowPositionRanges = event.beforeFromRowPositionRanges;
        this.beforeFromRowIndexes = new ArrayList<Integer>(event.beforeFromRowIndexes);
        this.beforeToRowPosition = event.beforeToRowPosition;
        this.beforeToRowIndex = event.beforeToRowIndex;
        this.reorderToTopEdge = event.reorderToTopEdge;
    }

    public Collection<Integer> getBeforeFromRowIndexes() {
        return this.beforeFromRowIndexes;
    }

    public Collection<Range> getBeforeFromRowPositionRanges() {
        return this.beforeFromRowPositionRanges;
    }

    public int getBeforeToRowPosition() {
        return this.beforeToRowPosition;
    }

    public int getBeforeToRowIndex() {
        return this.beforeToRowIndex;
    }

    public void setBeforeToRowIndex(int beforeIndex) {
        this.beforeToRowIndex = beforeIndex;
    }

    public boolean isReorderToTopEdge() {
        return this.reorderToTopEdge;
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        int beforeToRowPosition;
        ArrayList<StructuralDiff> rowDiffs = new ArrayList<StructuralDiff>();
        Collection<Range> beforeFromRowPositionRanges = this.getBeforeFromRowPositionRanges();
        int afterAddRowPosition = beforeToRowPosition = this.reorderToTopEdge ? this.beforeToRowPosition : this.beforeToRowPosition + 1;
        for (Range beforeFromRowPositionRange : beforeFromRowPositionRanges) {
            if (beforeFromRowPositionRange.start >= beforeToRowPosition) break;
            afterAddRowPosition -= Math.min(beforeFromRowPositionRange.end, beforeToRowPosition) - beforeFromRowPositionRange.start;
        }
        int cumulativeAddSize = 0;
        for (Range beforeFromRowPositionRange : beforeFromRowPositionRanges) {
            cumulativeAddSize += beforeFromRowPositionRange.size();
        }
        int offset = 0;
        for (Range beforeFromRowPositionRange : beforeFromRowPositionRanges) {
            int afterDeleteRowPosition = beforeFromRowPositionRange.start - offset;
            if (afterAddRowPosition < afterDeleteRowPosition) {
                afterDeleteRowPosition += cumulativeAddSize;
            }
            rowDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.DELETE, beforeFromRowPositionRange, new Range(afterDeleteRowPosition, afterDeleteRowPosition)));
            offset += beforeFromRowPositionRange.size();
        }
        Range beforeAddRange = new Range(beforeToRowPosition, beforeToRowPosition);
        offset = 0;
        for (Range beforeFromRowPositionRange : beforeFromRowPositionRanges) {
            int size = beforeFromRowPositionRange.size();
            rowDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.ADD, beforeAddRange, new Range(afterAddRowPosition + offset, afterAddRowPosition + offset + size)));
            offset += size;
        }
        return rowDiffs;
    }

    public void setConvertedBeforePositions(ILayer layer, Collection<Range> fromRowPositionRanges, int toRowPosition) {
        this.beforeLayer = layer;
        this.beforeFromRowPositionRanges = fromRowPositionRanges;
        this.beforeToRowPosition = toRowPosition;
    }

    @Override
    public boolean convertToLocal(ILayer targetLayer) {
        if (this.beforeLayer != targetLayer) {
            this.beforeFromRowPositionRanges = targetLayer.underlyingToLocalRowPositions(this.getLayer(), this.beforeFromRowPositionRanges);
            this.beforeToRowPosition = targetLayer.underlyingToLocalRowPosition(this.getLayer(), this.beforeToRowPosition);
            this.beforeLayer = targetLayer;
        }
        if (this.beforeToRowPosition >= 0) {
            return super.convertToLocal(targetLayer);
        }
        return false;
    }

    @Override
    public RowReorderEvent cloneEvent() {
        return new RowReorderEvent(this);
    }
}

