/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.PropertyUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowDeleteEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowInsertEvent;
import org.eclipse.swt.widgets.Display;

public class DetailGlazedListsEventLayer<T>
extends AbstractLayerTransform
implements IUniqueIndexLayer,
ListEventListener<T>,
PropertyChangeListener {
    private final IUniqueIndexLayer underlyingLayer;
    private EventList<T> eventList;
    private boolean active = true;

    public DetailGlazedListsEventLayer(IUniqueIndexLayer underlyingLayer, EventList<T> eventList) {
        super((ILayer)underlyingLayer);
        this.underlyingLayer = underlyingLayer;
        this.eventList = eventList;
        this.eventList.addListEventListener((ListEventListener)this);
    }

    public void listChanged(ListEvent<T> event) {
        if (this.active) {
            try {
                this.eventList.getReadWriteLock().readLock().lock();
                int currentEventType = -1;
                int deleteCount = 0;
                ArrayList<Range> deleteRanges = new ArrayList<Range>();
                ArrayList<Range> insertRanges = new ArrayList<Range>();
                while (event.next()) {
                    int eventType = event.getType();
                    if (currentEventType == -1) {
                        currentEventType = eventType;
                    } else if (currentEventType != eventType) {
                        this.internalFireEvents(deleteRanges, insertRanges);
                        deleteRanges.clear();
                        deleteCount = 0;
                        insertRanges.clear();
                    }
                    if (eventType == 0) {
                        int index = event.getIndex() + deleteCount;
                        deleteRanges.add(new Range(index, index + 1));
                        ++deleteCount;
                        continue;
                    }
                    if (eventType != 2) continue;
                    insertRanges.add(new Range(event.getIndex(), event.getIndex() + 1));
                }
                this.internalFireEvents(deleteRanges, insertRanges);
            }
            finally {
                this.eventList.getReadWriteLock().readLock().unlock();
            }
        }
    }

    private void internalFireEvents(final List<Range> deleteRanges, final List<Range> insertRanges) {
        if (!deleteRanges.isEmpty()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DetailGlazedListsEventLayer.this.fireLayerEvent((ILayerEvent)new RowDeleteEvent(DetailGlazedListsEventLayer.this.getUnderlyingLayer(), (Collection)deleteRanges));
                }
            });
        }
        if (!insertRanges.isEmpty()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DetailGlazedListsEventLayer.this.fireLayerEvent((ILayerEvent)new RowInsertEvent(DetailGlazedListsEventLayer.this.getUnderlyingLayer(), (Collection)insertRanges));
                }
            });
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        final PropertyUpdateEvent updateEvent = new PropertyUpdateEvent((ILayer)this, event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DetailGlazedListsEventLayer.this.fireLayerEvent((ILayerEvent)updateEvent);
            }
        });
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setEventList(EventList<T> newEventList) {
        this.eventList.removeListEventListener((ListEventListener)this);
        this.eventList = newEventList;
        this.eventList.addListEventListener((ListEventListener)this);
    }

    public int getColumnPositionByIndex(int columnIndex) {
        return this.underlyingLayer.getColumnPositionByIndex(columnIndex);
    }

    public int getRowPositionByIndex(int rowIndex) {
        return this.underlyingLayer.getRowPositionByIndex(rowIndex);
    }
}

