/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.command.GroupColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.GroupColumnReorderEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.GroupColumnReorderStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.GroupMultiColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnsAndGroupsCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class ColumnGroupReorderLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private static final Log log = LogFactory.getLog(ColumnGroupReorderLayer.class);
    private final ColumnGroupModel model;
    private int reorderFromColumnPosition;

    public ColumnGroupReorderLayer(IUniqueIndexLayer underlyingLayer, ColumnGroupModel model) {
        super(underlyingLayer);
        this.model = model;
        this.registerCommandHandlers();
    }

    public boolean reorderColumnGroup(int fromColumnPosition, int toColumnPosition) {
        int fromColumnIndex = this.underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
        List<Integer> fromColumnPositions = this.getColumnGroupPositions(fromColumnIndex);
        return this.underlyingLayer.doCommand(new MultiColumnReorderCommand(this, fromColumnPositions, toColumnPosition));
    }

    public ColumnGroupModel getModel() {
        return this.model;
    }

    @Override
    public IUniqueIndexLayer getUnderlyingLayer() {
        return (IUniqueIndexLayer)super.getUnderlyingLayer();
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new ReorderColumnGroupCommandHandler(this));
        this.registerCommandHandler(new ReorderColumnGroupStartCommandHandler(this));
        this.registerCommandHandler(new ReorderColumnGroupEndCommandHandler(this));
        this.registerCommandHandler(new ReorderColumnsAndGroupsCommandHandler(this));
        this.registerCommandHandler(new GroupColumnReorderCommandHandler(this));
        this.registerCommandHandler(new GroupMultiColumnReorderCommandHandler(this));
        this.registerCommandHandler(new GroupColumnReorderStartCommandHandler(this));
        this.registerCommandHandler(new GroupColumnReorderEndCommandHandler(this));
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.getUnderlyingLayer().getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.getUnderlyingLayer().getRowPositionByIndex(rowIndex);
    }

    public List<Integer> getColumnGroupPositions(int fromColumnIndex) {
        List<Integer> fromColumnIndexes = this.model.getColumnGroupByIndex(fromColumnIndex).getMembers();
        ArrayList<Integer> fromColumnPositions = new ArrayList<Integer>();
        for (Integer columnIndex : fromColumnIndexes) {
            fromColumnPositions.add(this.getUnderlyingLayer().getColumnPositionByIndex(columnIndex));
        }
        Collections.sort(fromColumnPositions);
        return fromColumnPositions;
    }

    public int getReorderFromColumnPosition() {
        return this.reorderFromColumnPosition;
    }

    public void setReorderFromColumnPosition(int fromColumnPosition) {
        this.reorderFromColumnPosition = fromColumnPosition;
    }

    public boolean updateColumnGroupModel(List<Integer> fromColumnPositions, int toColumnPosition, boolean reorderToLeftEdge) {
        boolean consumeCommand = false;
        int fromColumnPositionsCount = fromColumnPositions.size();
        if (toColumnPosition > fromColumnPositions.get(fromColumnPositionsCount - 1)) {
            int rightMostPosition = fromColumnPositions.get(fromColumnPositionsCount - 1);
            consumeCommand = this.updateColumnGroupModel(rightMostPosition, toColumnPosition, reorderToLeftEdge, fromColumnPositions);
        } else if (toColumnPosition < fromColumnPositions.get(fromColumnPositionsCount - 1)) {
            int leftMostPosition = fromColumnPositions.get(0);
            consumeCommand = this.updateColumnGroupModel(leftMostPosition, toColumnPosition, reorderToLeftEdge, fromColumnPositions);
        }
        return consumeCommand;
    }

    public boolean updateColumnGroupModel(int fromColumnPosition, int toColumnPosition, boolean reorderToLeftEdge) {
        return this.updateColumnGroupModel(fromColumnPosition, toColumnPosition, reorderToLeftEdge, Arrays.asList(fromColumnPosition));
    }

    protected int[] getColumnIndexesForPositions(List<Integer> fromColumnPositions) {
        int[] fromColumnIndexes = new int[fromColumnPositions.size()];
        int i = 0;
        while (i < fromColumnPositions.size()) {
            int from = fromColumnPositions.get(i);
            fromColumnIndexes[i] = this.getUnderlyingLayer().getColumnIndexByPosition(from);
            ++i;
        }
        return fromColumnIndexes;
    }

    public boolean updateColumnGroupModel(int fromColumnPosition, int toColumnPosition, boolean reorderToLeftEdge, List<Integer> fromColumnPositions) {
        SelectionLayer.MoveDirectionEnum moveDirection = ColumnGroupUtils.getMoveDirection(fromColumnPosition, toColumnPosition);
        if (reorderToLeftEdge && toColumnPosition > 0 && SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
            --toColumnPosition;
        }
        if (fromColumnPosition == -1 || toColumnPosition == -1) {
            log.error((Object)("Invalid reorder positions, fromPosition: " + fromColumnPosition + ", toPosition: " + toColumnPosition));
        }
        boolean jump = Math.abs(fromColumnPosition - toColumnPosition) > 1;
        int fromColumnIndex = this.getUnderlyingLayer().getColumnIndexByPosition(fromColumnPosition);
        int toColumnIndex = this.getUnderlyingLayer().getColumnIndexByPosition(toColumnPosition);
        ColumnGroupModel.ColumnGroup fromColumnGroup = this.model.getColumnGroupByIndex(fromColumnIndex);
        ColumnGroupModel.ColumnGroup toColumnGroup = this.model.getColumnGroupByIndex(toColumnIndex);
        int[] fromColumnIndexes = this.getColumnIndexesForPositions(fromColumnPositions);
        boolean consumeCommand = false;
        if (fromColumnGroup != null && toColumnGroup != null && fromColumnGroup.getName().equals(toColumnGroup.getName()) && fromColumnPosition == toColumnPosition) {
            if (fromColumnIndexes.length > 1) {
                if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
                    int collectionPos = fromColumnPositions.indexOf(fromColumnPosition);
                    if (collectionPos > 0) {
                        this.model.insertColumnIndexes(toColumnGroup.getName(), fromColumnIndexes);
                    } else {
                        this.model.removeColumnIndexes(fromColumnGroup.getName(), fromColumnIndexes);
                    }
                } else if (SelectionLayer.MoveDirectionEnum.LEFT == moveDirection) {
                    int collectionPos = fromColumnPositions.indexOf(fromColumnPosition);
                    if (collectionPos == 0) {
                        this.model.insertColumnIndexes(toColumnGroup.getName(), fromColumnIndexes);
                    } else {
                        this.model.removeColumnIndexes(fromColumnGroup.getName(), fromColumnIndexes);
                    }
                }
            } else if (ColumnGroupUtils.isLeftEdgeOfAColumnGroup(this, fromColumnPosition, fromColumnIndex, this.model) || ColumnGroupUtils.isRightEdgeOfAColumnGroup(this, fromColumnPosition, fromColumnIndex, this.model)) {
                this.model.removeColumnIndexes(fromColumnGroup.getName(), fromColumnIndexes);
            }
            consumeCommand = true;
        } else if (fromColumnGroup == null && toColumnGroup != null) {
            consumeCommand = this.model.insertColumnIndexes(toColumnGroup.getName(), fromColumnIndexes);
            if (jump) {
                consumeCommand = false;
            }
        } else if (fromColumnGroup != null && toColumnGroup == null) {
            this.model.removeColumnIndexes(fromColumnGroup.getName(), fromColumnIndexes);
        } else if (fromColumnGroup == null && toColumnGroup == null && fromColumnPosition == toColumnPosition) {
            int adjacentPos = moveDirection == SelectionLayer.MoveDirectionEnum.RIGHT ? fromColumnPosition + 1 : fromColumnPosition - 1;
            int adjacentIndex = this.getUnderlyingLayer().getColumnIndexByPosition(adjacentPos);
            ColumnGroupModel.ColumnGroup adjacentColumnGroup = this.model.getColumnGroupByIndex(adjacentIndex);
            if (adjacentColumnGroup != null) {
                this.model.insertColumnIndexes(adjacentColumnGroup.getName(), fromColumnIndexes);
                consumeCommand = false;
            }
        } else if (fromColumnGroup != null && toColumnGroup != null && !fromColumnGroup.getName().equals(toColumnGroup.getName())) {
            if (SelectionLayer.MoveDirectionEnum.RIGHT == moveDirection) {
                if (toColumnGroup != null) {
                    boolean fromRightEdge = ColumnGroupUtils.isRightEdgeOfAColumnGroup(this, fromColumnPosition, fromColumnIndex, this.model);
                    boolean removed = true;
                    if (fromColumnGroup != null) {
                        removed = this.model.removeColumnIndexes(fromColumnGroup.getName(), fromColumnIndexes);
                    }
                    if (removed && (!fromRightEdge && !jump || jump)) {
                        consumeCommand = this.model.insertColumnIndexes(toColumnGroup.getName(), fromColumnIndexes);
                        if (jump) {
                            consumeCommand = !jump;
                        }
                    } else {
                        consumeCommand = !jump;
                    }
                }
            } else if (SelectionLayer.MoveDirectionEnum.LEFT == moveDirection && toColumnGroup != null) {
                boolean fromLeftEdge = ColumnGroupUtils.isLeftEdgeOfAColumnGroup(this, fromColumnPosition, fromColumnIndex, this.model);
                boolean removed = true;
                if (fromColumnGroup != null) {
                    removed = this.model.removeColumnIndexes(fromColumnGroup.getName(), fromColumnIndexes);
                }
                if (removed && (!fromLeftEdge && !jump || jump)) {
                    consumeCommand = this.model.insertColumnIndexes(toColumnGroup.getName(), fromColumnIndexes);
                    if (jump) {
                        consumeCommand = !jump;
                    }
                } else {
                    consumeCommand = !jump;
                }
            }
        }
        return consumeCommand;
    }
}

