/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.config;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DialogErrorHandling
extends AbstractEditErrorHandler {
    protected ICellEditor editor;
    protected boolean allowCommit = false;
    private String failureShellTitle = "%DialogErrorHandlingStrategy.failureTitle";
    private String conversionFailureShellTitle = "%DialogErrorHandlingStrategy.conversionFailureTitle";
    private String validationFailureShellTitle = "%DialogErrorHandlingStrategy.validationFailureTitle";
    private String changeButtonLabel = "%DialogErrorHandlingStrategy.warningDialog.changeButton";
    private String discardButtonLabel = "%DialogErrorHandlingStrategy.warningDialog.discardButton";
    private String commitButtonLabel = "%DialogErrorHandlingStrategy.warningDialog.commitButton";

    public DialogErrorHandling() {
        this(null, false);
    }

    public DialogErrorHandling(boolean allowCommit) {
        this(null, allowCommit);
    }

    public DialogErrorHandling(IEditErrorHandler underlyingErrorHandler) {
        this(underlyingErrorHandler, false);
    }

    public DialogErrorHandling(IEditErrorHandler underlyingErrorHandler, boolean allowCommit) {
        super(underlyingErrorHandler);
        this.allowCommit = allowCommit;
    }

    @Override
    public void displayError(ICellEditor cellEditor, Exception e) {
        super.displayError(cellEditor, e);
        this.editor = cellEditor;
        String shellTitle = this.getFailureShellTitle();
        if (e instanceof ConversionFailedException && !this.getConversionFailureShellTitle().isEmpty()) {
            shellTitle = this.getConversionFailureShellTitle();
        } else if (e instanceof ValidationFailedException && !this.getValidationFailureShellTitle().isEmpty()) {
            shellTitle = this.getValidationFailureShellTitle();
        }
        this.showWarningDialog(e.getLocalizedMessage(), shellTitle);
    }

    protected void showWarningDialog(String dialogMessage, String dialogTitle) {
        if (!this.isWarningDialogActive() && dialogMessage != null) {
            String[] stringArray;
            if (this.allowCommit) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = this.getChangeButtonLabel();
                stringArray2[1] = this.getDiscardButtonLabel();
                stringArray = stringArray2;
                stringArray2[2] = this.getCommitButtonLabel();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = this.getChangeButtonLabel();
                stringArray = stringArray3;
                stringArray3[1] = this.getDiscardButtonLabel();
            }
            String[] buttonLabels = stringArray;
            MessageDialog warningDialog = new MessageDialog(Display.getDefault().getActiveShell(), dialogTitle, null, dialogMessage, 4, buttonLabels, 0);
            int returnCode = warningDialog.open();
            if (returnCode == 1) {
                this.editor.close();
            } else if (returnCode == 2) {
                this.editor.commit(SelectionLayer.MoveDirectionEnum.NONE, true, true);
            }
        }
    }

    protected boolean isWarningDialogActive() {
        Shell control = Display.getDefault().getActiveShell();
        return control != null && (this.getConversionFailureShellTitle().equals(control.getText()) || this.getValidationFailureShellTitle().equals(control.getText()) || this.getFailureShellTitle().equals(control.getText()));
    }

    public String getFailureShellTitle() {
        return this.getLocalized(this.failureShellTitle);
    }

    public void setFailureShellTitle(String failureShellTitle) {
        this.failureShellTitle = failureShellTitle;
    }

    public String getConversionFailureShellTitle() {
        return this.getLocalized(this.conversionFailureShellTitle);
    }

    public void setConversionFailureShellTitle(String conversionFailureShellTitle) {
        this.conversionFailureShellTitle = conversionFailureShellTitle;
    }

    public String getValidationFailureShellTitle() {
        return this.getLocalized(this.validationFailureShellTitle);
    }

    public void setValidationFailureShellTitle(String validationFailureShellTitle) {
        this.validationFailureShellTitle = validationFailureShellTitle;
    }

    public String getChangeButtonLabel() {
        return this.getLocalized(this.changeButtonLabel);
    }

    public void setChangeButtonLabel(String changeButtonLabel) {
        this.changeButtonLabel = changeButtonLabel;
    }

    public String getDiscardButtonLabel() {
        return this.getLocalized(this.discardButtonLabel);
    }

    public void setDiscardButtonLabel(String discardButtonLabel) {
        this.discardButtonLabel = discardButtonLabel;
    }

    public String getCommitButtonLabel() {
        return this.getLocalized(this.commitButtonLabel);
    }

    public void setCommitButtonLabel(String commitButtonLabel) {
        this.commitButtonLabel = commitButtonLabel;
    }

    private String getLocalized(String text) {
        return text != null ? Messages.getLocalizedMessage(text) : "";
    }
}

