/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.runner;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.nebula.widgets.nattable.examples.INatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.NavContentProvider;
import org.eclipse.nebula.widgets.nattable.examples.runner.NavLabelProvider;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class TabbedNatExampleRunner {
    private static CTabFolder tabFolder;
    private static Map<INatExample, Control> exampleControlMap;
    private static Map<String, INatExample> examplePathMap;
    private static Link link;

    static {
        exampleControlMap = new HashMap<INatExample, Control>();
        examplePathMap = new HashMap<String, INatExample>();
    }

    public static void run(String ... examplePaths) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        TabbedNatExampleRunner.run(1000, 600, examplePaths);
    }

    public static void run(int shellWidth, int shellHeight, String ... examplePaths) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 1264);
        shell.setLayout((Layout)new GridLayout(2, false));
        shell.setSize(shellWidth, shellHeight);
        shell.setText("NatTable Examples Application");
        Image nebula16 = new Image((Device)display, TabbedNatExampleRunner.class.getResourceAsStream("nebula_logo_16.png"));
        Image nebula32 = new Image((Device)display, TabbedNatExampleRunner.class.getResourceAsStream("nebula_logo_32.png"));
        Image nebula64 = new Image((Device)display, TabbedNatExampleRunner.class.getResourceAsStream("nebula_logo_64.png"));
        shell.setImages(new Image[]{nebula16, nebula32, nebula64});
        final TreeViewer navTreeViewer = new TreeViewer((Composite)shell);
        GridData gridData = new GridData(1040);
        gridData.widthHint = 300;
        navTreeViewer.getControl().setLayoutData((Object)gridData);
        final NavContentProvider contentProvider = new NavContentProvider();
        navTreeViewer.setContentProvider((IContentProvider)contentProvider);
        navTreeViewer.setLabelProvider((IBaseLabelProvider)new NavLabelProvider(contentProvider));
        navTreeViewer.setInput((Object)examplePaths);
        navTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                TreePath[] treePathArray = selection.getPaths();
                int n = treePathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath path = treePathArray[n2];
                    if (contentProvider.hasChildren(path.getLastSegment().toString())) {
                        boolean expanded = navTreeViewer.getExpandedState((Object)path);
                        navTreeViewer.setExpandedState((Object)path, !expanded);
                    } else {
                        TabbedNatExampleRunner.openExampleInTab(path.getLastSegment().toString());
                    }
                    ++n2;
                }
            }
        });
        tabFolder = new CTabFolder((Composite)shell, 2048);
        tabFolder.setLayoutData((Object)new GridData(1808));
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        for (INatExample example : exampleControlMap.keySet()) {
            example.onStop();
            Control exampleControl = exampleControlMap.get(example);
            exampleControl.dispose();
        }
        tabFolder.dispose();
        shell.dispose();
        display.dispose();
    }

    public static Class<? extends INatExample> getExampleClass(String examplePath) {
        String className = examplePath.replace('/', '.');
        try {
            Class<?> clazz = Class.forName(className);
            if (INatExample.class.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers())) {
                return clazz;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static INatExample getExample(String examplePath) {
        INatExample example = examplePathMap.get(examplePath);
        if (example == null) {
            Class<? extends INatExample> exampleClass;
            String path = examplePath;
            if (examplePath.startsWith("/Tutorial Examples/")) {
                path = examplePath.replace("/Tutorial Examples/", "/org/eclipse/nebula/widgets/nattable/examples/");
            } else if (examplePath.startsWith("/Classic Examples/")) {
                path = examplePath.replace("/Classic Examples/", "/org/eclipse/nebula/widgets/nattable/examples/examples/");
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((exampleClass = TabbedNatExampleRunner.getExampleClass(path)) != null) {
                try {
                    example = exampleClass.newInstance();
                    examplePathMap.put(examplePath, example);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return example;
    }

    private static void openExampleInTab(final String examplePath) {
        final INatExample example = TabbedNatExampleRunner.getExample(examplePath);
        if (example == null) {
            return;
        }
        final String exampleName = example.getName();
        CTabItem tabItem = new CTabItem(tabFolder, 64);
        tabItem.setText(exampleName);
        tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                example.onStop();
                Control exampleControl = (Control)exampleControlMap.get(example);
                if (exampleControl != null && !exampleControl.isDisposed()) {
                    exampleControl.dispose();
                }
                exampleControlMap.remove(example);
                examplePathMap.remove(examplePath);
                link.dispose();
            }
        });
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tabComposite.setLayout((Layout)new GridLayout(1, false));
        Control exampleControl = example.createExampleControl(tabComposite);
        exampleControl.setLayoutData((Object)new GridData(1808));
        exampleControlMap.put(example, exampleControl);
        String description = example.getDescription();
        if (description != null && description.length() > 0) {
            Group descriptionGroup = new Group(tabComposite, 0);
            descriptionGroup.setText("Description");
            descriptionGroup.setLayoutData((Object)new GridData(768));
            descriptionGroup.setLayout((Layout)new FillLayout());
            Label descriptionLabel = new Label((Composite)descriptionGroup, 64);
            descriptionLabel.setText(description);
        }
        link = new Link(tabComposite, 0);
        link.setText("<a href=\"" + examplePath + "\">View source</a>");
        SelectionAdapter linkSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String path = event.text;
                if (path.startsWith("/Tutorial Examples/")) {
                    path = path.replace("/Tutorial Examples/", "/org/eclipse/nebula/widgets/nattable/examples/");
                } else if (path.startsWith("/Classic Examples/")) {
                    path = path.replace("/Classic Examples/", "/org/eclipse/nebula/widgets/nattable/examples/examples/");
                }
                String source = TabbedNatExampleRunner.getResourceAsString(String.valueOf(path) + ".java");
                if (source != null) {
                    TabbedNatExampleRunner.viewSource(exampleName, source);
                }
            }
        };
        link.addSelectionListener((SelectionListener)linkSelectionListener);
        tabItem.setControl((Control)tabComposite);
        example.onStart();
        tabFolder.setSelection(tabItem);
    }

    private static String getResourceAsString(String resource) {
        InputStream inStream = TabbedNatExampleRunner.class.getResourceAsStream(resource);
        if (inStream != null) {
            StringBuffer strBuf = new StringBuffer();
            try {
                int i = -1;
                while ((i = inStream.read()) != -1) {
                    strBuf.append((char)i);
                }
                return strBuf.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("null stream for resource " + resource);
        }
        return null;
    }

    private static void viewSource(String title, String source) {
        Shell shell = new Shell(Display.getDefault());
        shell.setText(title);
        shell.setLayout((Layout)new FillLayout());
        Browser text = new Browser((Composite)shell, 2);
        text.setBackground(GUIHelper.COLOR_WHITE);
        text.setText("<pre>" + source + "</pre>");
        shell.open();
    }
}

