/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.fixtures;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataFixture;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataListFixture;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsStaticFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.stack.DefaultBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;

public class StaticFilterExampleGridLayer
extends GridLayer {
    private final ListDataProvider<RowDataFixture> bodyDataProvider;
    private final DataLayer bodyDataLayer;

    public StaticFilterExampleGridLayer(IConfigRegistry configRegistry) {
        super(true);
        EventList eventList = GlazedLists.eventList((Collection)RowDataListFixture.getList());
        TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
        SortedList sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
        FilterList filterList = new FilterList((EventList)sortedList);
        String[] propertyNames = RowDataListFixture.getPropertyNames();
        Map propertyToLabelMap = RowDataListFixture.getPropertyToLabelMap();
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        this.bodyDataProvider = new ListDataProvider((List)filterList, (IColumnAccessor)columnPropertyAccessor);
        this.bodyDataLayer = new DataLayer(this.bodyDataProvider);
        GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)this.bodyDataLayer, eventList);
        DefaultBodyLayerStack bodyLayer = new DefaultBodyLayerStack((IUniqueIndexLayer)glazedListsEventLayer);
        ColumnOverrideLabelAccumulator bodyLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)this.bodyDataLayer);
        this.bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)bodyLabelAccumulator);
        bodyLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"pricing_type"), new String[]{"PRICING_TYPE_PROP_NAME"});
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)bodyLayer, bodyLayer.getSelectionLayer());
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new GlazedListsSortModel(sortedList, (IColumnPropertyAccessor)columnPropertyAccessor, configRegistry, (ILayer)columnHeaderDataLayer), false);
        sortHeaderLayer.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        DefaultGlazedListsStaticFilterStrategy filterStrategy = new DefaultGlazedListsStaticFilterStrategy(filterList, (IColumnAccessor)columnPropertyAccessor, configRegistry);
        filterStrategy.addStaticFilter((Matcher)new Matcher<RowDataFixture>(){

            public boolean matches(RowDataFixture item) {
                return !item.rating.equals("AAA");
            }
        });
        FilterRowHeaderComposite filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)filterStrategy, (ILayer)sortHeaderLayer, (IDataProvider)columnHeaderDataProvider, configRegistry);
        ColumnOverrideLabelAccumulator labelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)columnHeaderDataLayer);
        columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)labelAccumulator);
        labelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"rating"), new String[]{"CUSTOM_COMPARATOR_LABEL"});
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)bodyLayer, bodyLayer.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)filterRowHeaderLayer);
        this.setBodyLayer((ILayer)bodyLayer);
        this.setColumnHeaderLayer((ILayer)filterRowHeaderLayer);
        this.setRowHeaderLayer((ILayer)rowHeaderLayer);
        this.setCornerLayer((ILayer)cornerLayer);
    }

    public ListDataProvider<RowDataFixture> getBodyDataProvider() {
        return this.bodyDataProvider;
    }

    public DataLayer getBodyDataLayer() {
        return this.bodyDataLayer;
    }
}

