/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._131_Filtering;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.PricingTypeBean;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataFixture;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.PersistentNatExampleWrapper;
import org.eclipse.nebula.widgets.nattable.examples.examples._110_Editing.EditableGridExample;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.PricingTypeBeanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.StaticFilterExampleGridLayer;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StaticFilterGridExample
extends AbstractNatExample {
    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(new PersistentNatExampleWrapper(new StaticFilterGridExample()));
    }

    @Override
    public String getDescription() {
        return "Grid demonstrates the usage of a static filter.\n\nFeatures:\nThis example shows only RowDataFixtures with ratings other than 'AAA'.\nIt is also sortable and editable and has a filter row to show that the static filter\nalso works with some other features.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ConfigRegistry configRegistry = new ConfigRegistry();
        StaticFilterExampleGridLayer underlyingLayer = new StaticFilterExampleGridLayer((IConfigRegistry)configRegistry);
        DataLayer bodyDataLayer = underlyingLayer.getBodyDataLayer();
        ListDataProvider<RowDataFixture> dataProvider = underlyingLayer.getBodyDataProvider();
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        NatTable natTable = new NatTable(parent, (ILayer)underlyingLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable));
        natTable.addConfiguration((IConfiguration)new FilterRowCustomConfiguration());
        natTable.addConfiguration((IConfiguration)EditableGridExample.editableGridConfiguration(columnLabelAccumulator, dataProvider));
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.configure();
        return natTable;
    }

    private static Comparator<?> getIngnorecaseComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        };
    }

    static class FilterRowCustomConfiguration
    extends AbstractRegistryConfiguration {
        final DefaultDoubleDisplayConverter doubleDisplayConverter = new DefaultDoubleDisplayConverter();

        FilterRowCustomConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, (Object)StaticFilterGridExample.getIngnorecaseComparator(), "NORMAL", "FILTER_COLUMN_2");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)this.doubleDisplayConverter, "NORMAL", "FILTER_COLUMN_5");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, (Object)TextMatchingMode.REGULAR_EXPRESSION, "NORMAL", "FILTER_COLUMN_5");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)this.doubleDisplayConverter, "NORMAL", "FILTER_COLUMN_6");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, (Object)TextMatchingMode.REGULAR_EXPRESSION, "NORMAL", "FILTER_COLUMN_6");
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new ComboBoxCellEditor(Arrays.asList(new PricingTypeBean("MN"), new PricingTypeBean("AT"))), "NORMAL", "FILTER_COLUMN_4");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)new PricingTypeBeanDisplayConverter(), "NORMAL", "FILTER_COLUMN_4");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new PricingTypeBeanDisplayConverter(), "NORMAL", "FILTER_COLUMN_4");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new PricingTypeBeanDisplayConverter(), "NORMAL", "PRICING_TYPE_PROP_NAME");
        }
    }
}

