/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._102_Configuration;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DummyColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultColumnHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultColumnHeaderStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.painter.cell.GradientBackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.VerticalTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.LineBorderDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TextPainter_Examples
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new TextPainter_Examples());
    }

    @Override
    public String getDescription() {
        return "The way content is rendered as text into cells is defined via TextPainter.\nThe TextPainter can be configured to wrap text and/or calculate the cell borders. In the first row are examples showing the normal TextPainter with various configurations,the second row shows various configurations of the VerticalTextPainter.Following configurations are used for the tables by column:\n1: no wrap, no calculate (default) - the content is cutted and showed with ...\n2: wrap, no calculate - the content is modified with new lines but showed with ... if it still doesn't fit\n3: no wrap, calculate - the content is showed completely as the cell will grow with its content (one line).\n4: wrap, calculate - the content is showed completely as the cell will grow with its content by wrapping the text.\n5: wrap, calculate, spacing used - the content is showed completely as the cell will grow with its content by wrapping the text.\n6: wrap, calculate, spacing used, wrapped by PaddingDecorator - the content is showed completely as the cell will grow with its content by wrapping the text.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Composite tableContainer = new Composite(parent, 0);
        tableContainer.setLayout((Layout)new GridLayout(6, true));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableContainer);
        this.createNatTable(tableContainer, (ICellPainter)new GradientBackgroundPainter((ICellPainter)new TextPainter(false, false, false), true));
        this.createNatTable(tableContainer, (ICellPainter)new TextPainter(true, true, false));
        this.createNatTable(tableContainer, (ICellPainter)new TextPainter(false, true, true));
        this.createNatTable(tableContainer, (ICellPainter)new TextPainter(true, true, true));
        this.createNatTable(tableContainer, (ICellPainter)new TextPainter(true, true, 5, true));
        this.createNatTable(tableContainer, (ICellPainter)new PaddingDecorator((ICellPainter)new TextPainter(true, true, 5, true), 5));
        this.createVerticalHeaderNatTable(tableContainer, (ICellPainter)new VerticalTextPainter(false, true, false));
        this.createVerticalHeaderNatTable(tableContainer, (ICellPainter)new VerticalTextPainter(true, true, false));
        this.createVerticalHeaderNatTable(tableContainer, (ICellPainter)new GradientBackgroundPainter((ICellPainter)new VerticalTextPainter(false, false, true)));
        this.createVerticalHeaderNatTable(tableContainer, (ICellPainter)new VerticalTextPainter(true, true, true));
        this.createVerticalHeaderNatTable(tableContainer, (ICellPainter)new VerticalTextPainter(true, true, 5, true));
        this.createVerticalHeaderNatTable(tableContainer, (ICellPainter)new PaddingDecorator((ICellPainter)new VerticalTextPainter(true, true, 5, true), 5));
        TextPainter underlineTextPainer = new TextPainter();
        underlineTextPainer.setUnderline(true);
        this.createNatTable2(tableContainer, (ICellPainter)underlineTextPainer);
        TextPainter strikethroughTextPainer = new TextPainter();
        strikethroughTextPainer.setStrikethrough(true);
        this.createNatTable2(tableContainer, (ICellPainter)strikethroughTextPainer);
        TextPainter underlineStrikethroughTextPainer = new TextPainter();
        underlineStrikethroughTextPainer.setUnderline(true);
        underlineStrikethroughTextPainer.setStrikethrough(true);
        this.createNatTable2(tableContainer, (ICellPainter)underlineStrikethroughTextPainer);
        VerticalTextPainter vunderlineTextPainer = new VerticalTextPainter(true, true, true);
        vunderlineTextPainer.setUnderline(true);
        this.createVerticalHeaderNatTable(tableContainer, (ICellPainter)vunderlineTextPainer);
        VerticalTextPainter vstrikethroughTextPainer = new VerticalTextPainter(true, true, true);
        vstrikethroughTextPainer.setStrikethrough(true);
        this.createVerticalHeaderNatTable(tableContainer, (ICellPainter)vstrikethroughTextPainer);
        VerticalTextPainter vunderlineStrikethroughTextPainer = new VerticalTextPainter(true, true, true);
        vunderlineStrikethroughTextPainer.setUnderline(true);
        vunderlineStrikethroughTextPainer.setStrikethrough(true);
        this.createVerticalHeaderNatTable(tableContainer, (ICellPainter)vunderlineStrikethroughTextPainer);
        return tableContainer;
    }

    private void createNatTable(Composite parent, ICellPainter painter) {
        ExampleTextBodyDataProvider bodyDataProvider = new ExampleTextBodyDataProvider();
        DataLayer dataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        dataLayer.setRowHeightByPosition(0, 32);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)dataLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DummyColumnHeaderDataProvider((IDataProvider)bodyDataProvider)), (ILayer)viewportLayer, selectionLayer);
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compositeLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration(painter){
            {
                this.vAlign = VerticalAlignmentEnum.TOP;
                this.hAlign = HorizontalAlignmentEnum.LEFT;
                this.cellPainter = new LineBorderDecorator(iCellPainter);
            }
        });
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
    }

    private void createNatTable2(Composite parent, final ICellPainter painter) {
        ExampleTextBodyDataProvider bodyDataProvider = new ExampleTextBodyDataProvider();
        DataLayer dataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        dataLayer.setRowHeightByPosition(0, 32);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)dataLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new ExampleHeaderDataProvider()), (ILayer)viewportLayer, selectionLayer, false);
        columnHeaderLayer.addConfiguration((IConfiguration)new DefaultColumnHeaderLayerConfiguration(){

            protected void addColumnHeaderStyleConfig() {
                this.addConfiguration((IConfiguration)new DefaultColumnHeaderStyleConfiguration(painter){
                    {
                        this.cellPainter = new BeveledBorderDecorator(iCellPainter);
                    }
                });
            }
        });
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compositeLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration(painter){
            {
                this.vAlign = VerticalAlignmentEnum.TOP;
                this.hAlign = HorizontalAlignmentEnum.LEFT;
                this.cellPainter = new LineBorderDecorator(iCellPainter);
            }
        });
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
    }

    private void createVerticalHeaderNatTable(Composite parent, final ICellPainter painter) {
        ExampleHeaderDataProvider bodyDataProvider = new ExampleHeaderDataProvider();
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)bodyDataProvider));
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new ExampleHeaderDataProvider()), (ILayer)viewportLayer, selectionLayer, false);
        columnHeaderLayer.addConfiguration((IConfiguration)new DefaultColumnHeaderLayerConfiguration(){

            protected void addColumnHeaderStyleConfig() {
                this.addConfiguration((IConfiguration)new DefaultColumnHeaderStyleConfiguration(painter){
                    {
                        this.cellPainter = new BeveledBorderDecorator(iCellPainter);
                    }
                });
            }
        });
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compositeLayer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
    }

    private void createNatTable3(Composite parent, ICellPainter painter) {
        ExampleHeaderDataProvider bodyDataProvider = new ExampleHeaderDataProvider();
        DataLayer dataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)dataLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DummyColumnHeaderDataProvider((IDataProvider)bodyDataProvider)), (ILayer)viewportLayer, selectionLayer);
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compositeLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration(painter){
            {
                this.vAlign = VerticalAlignmentEnum.TOP;
                this.hAlign = HorizontalAlignmentEnum.LEFT;
                this.cellPainter = new LineBorderDecorator(iCellPainter);
                this.font = GUIHelper.getFont((FontData[])new FontData[]{new FontData("Arial", 20, 0)});
            }
        });
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
    }

    private void createVerticalNatTable(Composite parent, ICellPainter painter) {
        ExampleHeaderDataProvider bodyDataProvider = new ExampleHeaderDataProvider();
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)bodyDataProvider, 20, 100));
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DummyColumnHeaderDataProvider((IDataProvider)bodyDataProvider), 20, 100), (ILayer)viewportLayer, selectionLayer);
        columnHeaderLayer.addConfiguration((IConfiguration)new DefaultColumnHeaderLayerConfiguration(){

            protected void addColumnHeaderStyleConfig() {
                this.addConfiguration((IConfiguration)new DefaultColumnHeaderStyleConfiguration(){
                    {
                        this.cellPainter = new BeveledBorderDecorator((ICellPainter)new VerticalTextPainter());
                    }
                });
            }
        });
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compositeLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration(painter){
            {
                this.vAlign = VerticalAlignmentEnum.MIDDLE;
                this.hAlign = HorizontalAlignmentEnum.LEFT;
                this.cellPainter = new LineBorderDecorator(iCellPainter);
                this.font = GUIHelper.getFont((FontData[])new FontData[]{new FontData("Arial", 20, 0)});
            }
        });
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
    }

    class ExampleHeaderDataProvider
    implements IDataProvider {
        ExampleHeaderDataProvider() {
        }

        public Object getDataValue(int columnIndex, int rowIndex) {
            return "Lorem ipsum";
        }

        public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            throw new UnsupportedOperationException();
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }
    }

    class ExampleTextBodyDataProvider
    implements IDataProvider {
        ExampleTextBodyDataProvider() {
        }

        public Object getDataValue(int columnIndex, int rowIndex) {
            return "Lorem\nipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy.";
        }

        public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            throw new UnsupportedOperationException();
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }
    }
}

