/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._102_Configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.dataset.NumberValues;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.examples._102_Configuration.TableDecorationConfiguration;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultGridLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CellPainterDecorator_Example
extends AbstractNatExample {
    public static final String COLUMN_ONE_LABEL = "ColumnOneLabel";
    public static final String COLUMN_TWO_LABEL = "ColumnTwoLabel";
    public static final String COLUMN_THREE_LABEL = "ColumnThreeLabel";
    public static final String COLUMN_FOUR_LABEL = "ColumnFourLabel";
    public static final String COLUMN_FIVE_LABEL = "ColumnFiveLabel";
    public static final String COLUMN_SIX_LABEL = "ColumnSixLabel";
    public static final String COLUMN_SEVEN_LABEL = "ColumnSevenLabel";
    public static final String COLUMN_EIGHT_LABEL = "ColumnEightLabel";

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new CellPainterDecorator_Example());
    }

    @Override
    public String getDescription() {
        return "This example demonstrates the different possibilities to add decoration to a cell.\nThe first NatTable instance shows how to use decoration dependent rendering, which means that the base painter and the decoration painter are sharing the cell as equal partners. So the base painter has less space.\nThe second NatTable instance shows how to decorate a cell without implications to the base painter. This means the base painter renders normally while the decorator will simply paint over the base painter.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Composite tableContainer = new Composite(parent, 0);
        tableContainer.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableContainer);
        this.createNatTable(tableContainer, true);
        this.createNatTable(tableContainer, false);
        return tableContainer;
    }

    private void createNatTable(Composite parent, boolean paintDecorationDependent) {
        String[] propertyNames = new String[]{"columnOneNumber", "columnTwoNumber", "columnThreeNumber", "columnFourNumber", "columnFiveNumber", "columnSixNumber", "columnSevenNumber", "columnEightNumber"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("columnOneNumber", "C 1");
        propertyToLabelMap.put("columnTwoNumber", "C 2");
        propertyToLabelMap.put("columnThreeNumber", "C 3");
        propertyToLabelMap.put("columnFourNumber", "C 4");
        propertyToLabelMap.put("columnFiveNumber", "C 5");
        propertyToLabelMap.put("columnSixNumber", "C 6");
        propertyToLabelMap.put("columnSevenNumber", "C 7");
        propertyToLabelMap.put("columnEightNumber", "C 8");
        DefaultGridLayer gridLayer = new DefaultGridLayer(this.createNumberValuesList(), propertyNames, propertyToLabelMap);
        DataLayer bodyDataLayer = (DataLayer)gridLayer.getBodyDataLayer();
        bodyDataLayer.setDefaultRowHeight(40);
        bodyDataLayer.setDefaultColumnWidth(40);
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        this.registerColumnLabels(columnLabelAccumulator);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new TableDecorationConfiguration(paintDecorationDependent));
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
    }

    private List<NumberValues> createNumberValuesList() {
        ArrayList<NumberValues> result = new ArrayList<NumberValues>();
        NumberValues nv = null;
        int i = 0;
        while (i < 3) {
            nv = new NumberValues();
            nv.setColumnOneNumber(111);
            nv.setColumnTwoNumber(222);
            nv.setColumnThreeNumber(333);
            nv.setColumnFourNumber(444);
            nv.setColumnFiveNumber(555);
            nv.setColumnSixNumber(666);
            nv.setColumnSevenNumber(777);
            nv.setColumnEightNumber(888);
            nv.setColumnNineNumber(999);
            result.add(nv);
            ++i;
        }
        return result;
    }

    private void registerColumnLabels(ColumnOverrideLabelAccumulator columnLabelAccumulator) {
        columnLabelAccumulator.registerColumnOverrides(0, new String[]{COLUMN_ONE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(1, new String[]{COLUMN_TWO_LABEL});
        columnLabelAccumulator.registerColumnOverrides(2, new String[]{COLUMN_THREE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(3, new String[]{COLUMN_FOUR_LABEL});
        columnLabelAccumulator.registerColumnOverrides(4, new String[]{COLUMN_FIVE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(5, new String[]{COLUMN_SIX_LABEL});
        columnLabelAccumulator.registerColumnOverrides(6, new String[]{COLUMN_SEVEN_LABEL});
        columnLabelAccumulator.registerColumnOverrides(7, new String[]{COLUMN_EIGHT_LABEL});
    }
}

