/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._102_Configuration;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.SelectionExampleGridLayer;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.CellOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.selection.config.DefaultSelectionLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Applying_style_to_a_cell
extends AbstractNatExample {
    private static final String CELL_LABEL = "Cell_LABEL";

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new Applying_style_to_a_cell());
    }

    @Override
    public String getDescription() {
        return "This example shows how to style cell(s) depending on the their data value.\n\nThe basic approach is to apply 'labels' to cells. Once a label is applied, you can register various config attributes against the label. During rendering, NatTable will apply all the registered attributes to the cells with matching labels.\n\nYou can apply labels in any fashion you like by implementing the IConfigLabelAccumulator interface. Out of the box, labels can be applied to whole columns, rows and cells.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        SelectionExampleGridLayer gridLayer = new SelectionExampleGridLayer();
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        DataLayer bodyDataLayer = gridLayer.getBodyDataLayer();
        CellOverrideLabelAccumulator cellLabelAccumulator = new CellOverrideLabelAccumulator(gridLayer.getBodyDataProvider());
        cellLabelAccumulator.registerOverride((Object)"AAA", 2, CELL_LABEL);
        ConfigRegistry configRegistry = new ConfigRegistry();
        this.addColumnHighlight((IConfigRegistry)configRegistry);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)cellLabelAccumulator);
        gridLayer.getSelectionLayer().addConfiguration((IConfiguration)new DefaultSelectionLayerConfiguration());
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.configure();
        return natTable;
    }

    private void addColumnHighlight(IConfigRegistry configRegistry) {
        Style style = new Style();
        style.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_RED);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", CELL_LABEL);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "SELECT", CELL_LABEL);
    }
}

