/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.SimplePerson;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _001_Getting_Started
extends AbstractNatExample {
    private IDataProvider bodyDataProvider;
    private String[] propertyNames;
    private BodyLayerStack bodyLayer;
    private Map<String, String> propertyToLabels;

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(600, 400, new _001_Getting_Started());
    }

    @Override
    public Control createExampleControl(Composite parent) {
        this.bodyDataProvider = this.setupBodyDataProvider();
        DefaultColumnHeaderDataProvider colHeaderDataProvider = new DefaultColumnHeaderDataProvider(this.propertyNames, this.propertyToLabels);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.bodyDataProvider);
        this.bodyLayer = new BodyLayerStack(this.bodyDataProvider);
        ColumnHeaderLayerStack columnHeaderLayer = new ColumnHeaderLayerStack((IDataProvider)colHeaderDataProvider);
        RowHeaderLayerStack rowHeaderLayer = new RowHeaderLayerStack((IDataProvider)rowHeaderDataProvider);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)colHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)cornerDataProvider), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)this.bodyLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer);
        return natTable;
    }

    private IDataProvider setupBodyDataProvider() {
        List<SimplePerson> people = Arrays.asList(new SimplePerson(100, "Mickey Mouse", new Date(1000000L)), new SimplePerson(110, "Batman", new Date(2000000L)), new SimplePerson(120, "Bender", new Date(3000000L)), new SimplePerson(130, "Cartman", new Date(4000000L)), new SimplePerson(140, "Dogbert", new Date(5000000L)));
        this.propertyToLabels = new HashMap<String, String>();
        this.propertyToLabels.put("id", "ID");
        this.propertyToLabels.put("name", "First Name");
        this.propertyToLabels.put("birthDate", "DOB");
        this.propertyNames = new String[]{"id", "name", "birthDate"};
        return new ListDataProvider(people, (IColumnAccessor)new ReflectiveColumnPropertyAccessor(this.propertyNames));
    }

    public class BodyLayerStack
    extends AbstractLayerTransform {
        private SelectionLayer selectionLayer;

        public BodyLayerStack(IDataProvider dataProvider) {
            DataLayer bodyDataLayer = new DataLayer(dataProvider);
            ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)bodyDataLayer);
            ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)columnHideShowLayer);
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }
    }

    public class ColumnHeaderLayerStack
    extends AbstractLayerTransform {
        public ColumnHeaderLayerStack(IDataProvider dataProvider) {
            DataLayer dataLayer = new DataLayer(dataProvider);
            ColumnHeaderLayer colHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)dataLayer, (ILayer)_001_Getting_Started.this.bodyLayer, _001_Getting_Started.this.bodyLayer.getSelectionLayer());
            this.setUnderlyingLayer((ILayer)colHeaderLayer);
        }
    }

    public class RowHeaderLayerStack
    extends AbstractLayerTransform {
        public RowHeaderLayerStack(IDataProvider dataProvider) {
            DataLayer dataLayer = new DataLayer(dataProvider, 50, 20);
            RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)dataLayer, (ILayer)_001_Getting_Started.this.bodyLayer, _001_Getting_Started.this.bodyLayer.getSelectionLayer());
            this.setUnderlyingLayer((ILayer)rowHeaderLayer);
        }
    }
}

