/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._600_GlazedLists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.DetailGlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.hideshow.GlazedListsRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.menu.AbstractHeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _606_GlazedListsRowHideShowExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _606_GlazedListsRowHideShowExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of the row hide/show functionality within a grid and its corresponding actions in the row header menu using the GlazedLists extension. If you perform a right click on the row header, you are able to hide the current selected row or show all rows again.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        EventList eventList = GlazedLists.eventList((Collection)PersonService.getPersons((int)10));
        FilterList filterList = new FilterList(eventList);
        ListDataProvider bodyDataProvider = new ListDataProvider((List)filterList, (IColumnAccessor)new ReflectiveColumnPropertyAccessor(propertyNames));
        IRowIdAccessor<Person> rowIdAccessor = new IRowIdAccessor<Person>(){

            public Serializable getRowId(Person rowObject) {
                return Integer.valueOf(rowObject.getId());
            }
        };
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        DetailGlazedListsEventLayer glazedListsEventLayer = new DetailGlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, (EventList)filterList);
        GlazedListsRowHideShowLayer rowHideShowLayer = new GlazedListsRowHideShowLayer((ILayer)glazedListsEventLayer, (IRowDataProvider)bodyDataProvider, (IRowIdAccessor)rowIdAccessor, filterList);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)rowHideShowLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractHeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createRowHeaderMenu(NatTable natTable) {
                return new PopupMenuBuilder(natTable).withHideRowMenuItem().withShowAllRowsMenuItem();
            }

            protected PopupMenuBuilder createCornerMenu(NatTable natTable) {
                return super.createCornerMenu(natTable).withShowAllRowsMenuItem().withStateManagerMenuItemProvider();
            }
        });
        natTable.configure();
        natTable.registerCommandHandler((ILayerCommandHandler)new DisplayPersistenceDialogCommandHandler(natTable));
        return natTable;
    }
}

