/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._600_GlazedLists._605_GroupBy;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByDataLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class _6052_GroupByCustomTypesExample
extends AbstractNatExample {
    private List<City> possibleCities = new ArrayList<City>();

    public _6052_GroupByCustomTypesExample() {
        this.possibleCities.add(new City(1111, "Springfield"));
        this.possibleCities.add(new City(2222, "Shelbyville"));
        this.possibleCities.add(new City(3333, "Ogdenville"));
        this.possibleCities.add(new City(4444, "Waverly Hills"));
        this.possibleCities.add(new City(5555, "North Haverbrook"));
        this.possibleCities.add(new City(6666, "Capital City"));
    }

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _6052_GroupByCustomTypesExample());
    }

    @Override
    public String getDescription() {
        return "This example has a 'Group By' region at the top.\nIf you drag a column header into this region, rows in the grid will be grouped by this column.\nIf you right-click on the names in the Group By region, you can ungroup by the clicked column.\nYou can also change the visibility of the Group By region by toggling the visibility via context menu in the corner region.This example also shows the support for custom data types.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ConfigRegistry configRegistry = new ConfigRegistry();
        String[] propertyNames = new String[]{"name", "age", "money", "gender", "city"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("name", "Name");
        propertyToLabelMap.put("age", "Age");
        propertyToLabelMap.put("money", "Money");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("city", "City");
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        BodyLayerStack<MyRowObject> bodyLayerStack = new BodyLayerStack<MyRowObject>(this.createMyRowObjects(50), (IColumnPropertyAccessor<MyRowObject>)columnPropertyAccessor);
        bodyLayerStack.getBodyDataLayer().setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayerStack.getBodyDataProvider());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer(bodyLayerStack, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        CompositeLayer compositeGridLayer = new CompositeLayer(1, 2);
        final GroupByHeaderLayer groupByHeaderLayer = new GroupByHeaderLayer(bodyLayerStack.getGroupByModel(), (ILayer)gridLayer, (IDataProvider)columnHeaderDataProvider);
        compositeGridLayer.setChildLayer("GROUP_BY_REGION", (ILayer)groupByHeaderLayer, 0, 0);
        compositeGridLayer.setChildLayer("Grid", (ILayer)gridLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compositeGridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new GroupByHeaderMenuConfiguration(natTable, groupByHeaderLayer));
        natTable.addConfiguration((IConfiguration)new MyRowObjectTableConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createCornerMenu(NatTable natTable) {
                return super.createCornerMenu(natTable).withStateManagerMenuItemProvider().withMenuItemProvider(new IMenuItemProvider(){

                    public void addMenuItem(NatTable natTable, Menu popupMenu) {
                        MenuItem menuItem = new MenuItem(popupMenu, 8);
                        menuItem.setText("Toggle Group By Header");
                        menuItem.setEnabled(true);
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                groupByHeaderLayer.setVisible(!groupByHeaderLayer.isVisible());
                            }
                        });
                    }
                });
            }
        });
        ((BodyLayerStack)bodyLayerStack).bodyDataLayer.initializeTreeComparator((ISortModel)new GlazedListsSortModel(((BodyLayerStack)bodyLayerStack).sortedList, (IColumnPropertyAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry, (ILayer)columnHeaderDataLayer), null, false);
        natTable.configure();
        natTable.registerCommandHandler((ILayerCommandHandler)new DisplayPersistenceDialogCommandHandler(natTable));
        return natTable;
    }

    private List<MyRowObject> createMyRowObjects(int amount) {
        ArrayList<MyRowObject> result = new ArrayList<MyRowObject>();
        MyRowObject obj = null;
        int i = 0;
        while (i < amount) {
            obj = new MyRowObject();
            String[] maleNames = new String[]{"Bart", "Homer", "Lenny", "Carl", "Waylon", "Ned", "Timothy"};
            String[] femaleNames = new String[]{"Marge", "Lisa", "Maggie", "Edna", "Helen", "Jessica"};
            String[] lastNames = new String[]{"Simpson", "Leonard", "Carlson", "Smithers", "Flanders", "Krabappel", "Lovejoy"};
            Random randomGenerator = new Random();
            obj.setGender(MyRowObject.Gender.values()[randomGenerator.nextInt(2)]);
            if (obj.getGender().equals((Object)MyRowObject.Gender.MALE)) {
                obj.setName(String.valueOf(maleNames[randomGenerator.nextInt(maleNames.length)]) + " " + lastNames[randomGenerator.nextInt(lastNames.length)]);
            } else {
                obj.setName(String.valueOf(femaleNames[randomGenerator.nextInt(femaleNames.length)]) + " " + lastNames[randomGenerator.nextInt(lastNames.length)]);
            }
            obj.setAge(randomGenerator.nextInt(100));
            obj.setMoney(randomGenerator.nextDouble() * (double)randomGenerator.nextInt(100));
            obj.setCity(this.possibleCities.get(randomGenerator.nextInt(this.possibleCities.size())));
            result.add(obj);
            ++i;
        }
        return result;
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final SortedList<T> sortedList;
        private final IDataProvider bodyDataProvider;
        private final GroupByDataLayer<T> bodyDataLayer;
        private final SelectionLayer selectionLayer;
        private final GroupByModel groupByModel = new GroupByModel();

        public BodyLayerStack(List<T> values, IColumnPropertyAccessor<T> columnPropertyAccessor) {
            EventList eventList = GlazedLists.eventList(values);
            TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
            this.sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
            this.bodyDataLayer = new GroupByDataLayer(this.getGroupByModel(), this.sortedList, columnPropertyAccessor);
            this.bodyDataProvider = this.bodyDataLayer.getDataProvider();
            GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer(this.bodyDataLayer, this.sortedList);
            ColumnReorderLayer reorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)glazedListsEventLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)reorderLayer);
            TreeLayer treeLayer = new TreeLayer((IUniqueIndexLayer)this.selectionLayer, (ITreeRowModel)this.bodyDataLayer.getTreeRowModel());
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)treeLayer);
            this.setUnderlyingLayer((ILayer)viewportLayer);
            CopyDataCommandHandler copyHandler = new CopyDataCommandHandler(this.selectionLayer);
            copyHandler.setCopyLayer((IUniqueIndexLayer)treeLayer);
            copyHandler.setCopyFormattedText(true);
            this.registerCommandHandler((ILayerCommandHandler)copyHandler);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public SortedList<T> getSortedList() {
            return this.sortedList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }

        public DataLayer getBodyDataLayer() {
            return this.bodyDataLayer;
        }

        public GroupByModel getGroupByModel() {
            return this.groupByModel;
        }
    }

    public static class City {
        final int plz;
        final String name;

        City(int plz, String name) {
            this.plz = plz;
            this.name = name;
        }

        public int getPlz() {
            return this.plz;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class CityComparator
    implements Comparator<City> {
        @Override
        public int compare(City o1, City o2) {
            int result = 0;
            if (o1 != null && o2 != null && (result = Integer.valueOf(o1.plz).compareTo(o2.plz)) == 0) {
                result = o1.name.compareTo(o2.name);
            }
            return result;
        }
    }

    class CityDisplayConverter
    extends DisplayConverter {
        CityDisplayConverter() {
        }

        public Object canonicalToDisplayValue(Object canonicalValue) {
            if (canonicalValue instanceof City) {
                return String.valueOf(((City)canonicalValue).getPlz()) + " " + ((City)canonicalValue).getName();
            }
            return canonicalValue != null ? canonicalValue : "";
        }

        public Object displayToCanonicalValue(Object displayValue) {
            String plz = displayValue.toString().substring(0, 4);
            for (City city : _6052_GroupByCustomTypesExample.this.possibleCities) {
                if (city.getPlz() != Integer.valueOf(plz).intValue()) continue;
                return city;
            }
            return null;
        }
    }

    class GenderDisplayConverter
    extends DisplayConverter {
        GenderDisplayConverter() {
        }

        public Object canonicalToDisplayValue(Object canonicalValue) {
            if (canonicalValue instanceof MyRowObject.Gender) {
                String result = canonicalValue.toString();
                result = String.valueOf(result.substring(0, 1)) + result.substring(1).toLowerCase();
                return result;
            }
            return canonicalValue != null ? canonicalValue : "";
        }

        public Object displayToCanonicalValue(Object displayValue) {
            return MyRowObject.Gender.valueOf(displayValue.toString().toUpperCase());
        }
    }

    public static class MyRowObject {
        String name;
        int age;
        double money;
        Gender gender;
        City city;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getAge() {
            return this.age;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public double getMoney() {
            return this.money;
        }

        public void setMoney(double money) {
            this.money = money;
        }

        public Gender getGender() {
            return this.gender;
        }

        public void setGender(Gender gender) {
            this.gender = gender;
        }

        public City getCity() {
            return this.city;
        }

        public void setCity(City city) {
            this.city = city;
        }

        static enum Gender {
            MALE,
            FEMALE;

        }
    }

    class MyRowObjectTableConfiguration
    extends AbstractRegistryConfiguration {
        MyRowObjectTableConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), "NORMAL", "COLUMN_1");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDoubleDisplayConverter(), "NORMAL", "COLUMN_2");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new GenderDisplayConverter(), "NORMAL", "COLUMN_3");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new CityDisplayConverter(), "NORMAL", "COLUMN_4");
            configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, (Object)new CityComparator(), "NORMAL", "COLUMN_4");
        }
    }
}

