/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._600_GlazedLists._604_Tree;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.TreeList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDateDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonWithAddress;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeRowModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeCollapseAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandAllCommand;
import org.eclipse.nebula.widgets.nattable.tree.config.TreeLayerExpandCollapseKeyBindings;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _6041_TreeGridExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _6041_TreeGridExample());
    }

    @Override
    public String getDescription() {
        return "This example shows how to create a tree within a grid. It will use a child as the parent node for tree structuring.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        ConfigRegistry configRegistry = new ConfigRegistry();
        String[] propertyNames = new String[]{"lastName", "firstName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        BodyLayerStack<PersonWithAddress> bodyLayerStack = new BodyLayerStack<PersonWithAddress>(PersonService.getPersonsWithAddress((int)50), (IColumnPropertyAccessor<PersonWithAddress>)columnPropertyAccessor, new PersonWithAddressTreeFormat());
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayerStack.getBodyDataProvider());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, bodyLayerStack, bodyLayerStack.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer(bodyLayerStack, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        final NatTable natTable = new NatTable(container, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", "COLUMN_3");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDateDisplayConverter("MM/dd/yyyy"), "NORMAL", "COLUMN_4");
            }
        });
        natTable.addConfiguration((IConfiguration)new TreeLayerExpandCollapseKeyBindings(bodyLayerStack.getTreeLayer(), bodyLayerStack.getSelectionLayer()));
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Composite buttonPanel = new Composite(container, 0);
        buttonPanel.setLayout((Layout)new RowLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        Button collapseAllButton = new Button(buttonPanel, 8);
        collapseAllButton.setText("Collapse All");
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeCollapseAllCommand());
            }
        });
        Button expandAllButton = new Button(buttonPanel, 8);
        expandAllButton.setText("Expand All");
        expandAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                natTable.doCommand((ILayerCommand)new TreeExpandAllCommand());
            }
        });
        return container;
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final TreeList<T> treeList;
        private final IDataProvider bodyDataProvider;
        private final SelectionLayer selectionLayer;
        private final TreeLayer treeLayer;

        public BodyLayerStack(List<T> values, IColumnPropertyAccessor<T> columnPropertyAccessor, TreeList.Format<T> treeFormat) {
            EventList eventList = GlazedLists.eventList(values);
            TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
            SortedList sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
            this.treeList = new TreeList((EventList)sortedList, treeFormat, TreeList.NODES_START_EXPANDED);
            this.bodyDataProvider = new ListDataProvider(this.treeList, columnPropertyAccessor);
            DataLayer bodyDataLayer = new DataLayer(this.bodyDataProvider);
            bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
            GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, this.treeList);
            GlazedListTreeData treeData = new GlazedListTreeData(this.treeList);
            GlazedListTreeRowModel treeRowModel = new GlazedListTreeRowModel(treeData);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)glazedListsEventLayer);
            this.treeLayer = new TreeLayer((IUniqueIndexLayer)this.selectionLayer, (ITreeRowModel)treeRowModel);
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.treeLayer);
            this.setUnderlyingLayer((ILayer)viewportLayer);
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public TreeLayer getTreeLayer() {
            return this.treeLayer;
        }

        public TreeList<T> getTreeList() {
            return this.treeList;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }
    }

    private class PersonWithAddressTreeFormat
    implements TreeList.Format<PersonWithAddress> {
        private Map<String, PersonWithAddress> parentMapping = new HashMap<String, PersonWithAddress>();

        private PersonWithAddressTreeFormat() {
        }

        public void getPath(List<PersonWithAddress> path, PersonWithAddress element) {
            if (this.parentMapping.get(element.getLastName()) != null) {
                path.add(this.parentMapping.get(element.getLastName()));
            } else {
                this.parentMapping.put(element.getLastName(), element);
            }
            path.add(element);
        }

        public boolean allowsChildren(PersonWithAddress element) {
            return true;
        }

        public Comparator<? super PersonWithAddress> getComparator(int depth) {
            return new Comparator<PersonWithAddress>(){

                @Override
                public int compare(PersonWithAddress o1, PersonWithAddress o2) {
                    return o1.getLastName().compareTo(o2.getLastName());
                }
            };
        }
    }
}

