/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._512_SummaryRow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.NumberValues;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.DefaultSummaryRowConfiguration;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowLayer;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummationSummaryProvider;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _5121_SummaryRowExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5121_SummaryRowExample());
    }

    @Override
    public String getDescription() {
        return "This example demonstrates how to add a summary row to the end of the table.\n\nFeatures\n\tDifferent style can be applied to the whole row\n\tDifferent style can be applied to the individual cells in the summary row\n\tPlug-in your own summary formulas via ISummaryProvider interface (Default is summation)";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"columnOneNumber", "columnTwoNumber", "columnThreeNumber", "columnFourNumber", "columnFiveNumber"};
        ReflectiveColumnPropertyAccessor cpa = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider dataProvider = new ListDataProvider(this.createNumberValueList(), (IColumnAccessor)cpa);
        ConfigRegistry configRegistry = new ConfigRegistry();
        DataLayer dataLayer = new DataLayer((IDataProvider)dataProvider);
        SummaryRowLayer summaryRowLayer = new SummaryRowLayer((IUniqueIndexLayer)dataLayer, (IConfigRegistry)configRegistry, false);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)summaryRowLayer);
        NatTable natTable = new NatTable(parent, (ILayer)viewportLayer, false);
        natTable.addConfiguration((IConfiguration)new ExampleSummaryRowConfiguration((IDataProvider)dataProvider));
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.configure();
        return natTable;
    }

    private List<NumberValues> createNumberValueList() {
        ArrayList<NumberValues> result = new ArrayList<NumberValues>();
        NumberValues nv = new NumberValues();
        nv.setColumnOneNumber(5);
        nv.setColumnTwoNumber(4);
        nv.setColumnThreeNumber(3);
        nv.setColumnFourNumber(1);
        nv.setColumnFiveNumber(1);
        result.add(nv);
        nv = new NumberValues();
        nv.setColumnOneNumber(1);
        nv.setColumnTwoNumber(1);
        nv.setColumnThreeNumber(2);
        nv.setColumnFourNumber(2);
        nv.setColumnFiveNumber(3);
        result.add(nv);
        nv = new NumberValues();
        nv.setColumnOneNumber(1);
        nv.setColumnTwoNumber(2);
        nv.setColumnThreeNumber(2);
        nv.setColumnFourNumber(3);
        nv.setColumnFiveNumber(3);
        result.add(nv);
        nv = new NumberValues();
        nv.setColumnOneNumber(1);
        nv.setColumnTwoNumber(2);
        nv.setColumnThreeNumber(4);
        nv.setColumnFourNumber(4);
        nv.setColumnFiveNumber(3);
        result.add(nv);
        nv = new NumberValues();
        nv.setColumnOneNumber(5);
        nv.setColumnTwoNumber(4);
        nv.setColumnThreeNumber(4);
        nv.setColumnFourNumber(4);
        nv.setColumnFiveNumber(7);
        result.add(nv);
        return result;
    }

    class ExampleSummaryRowConfiguration
    extends DefaultSummaryRowConfiguration {
        private final IDataProvider dataProvider;

        public ExampleSummaryRowConfiguration(IDataProvider dataProvider) {
            this.dataProvider = dataProvider;
            this.summaryRowBgColor = GUIHelper.COLOR_BLUE;
            this.summaryRowFgColor = GUIHelper.COLOR_WHITE;
        }

        public void addSummaryProviderConfig(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new SummationSummaryProvider(this.dataProvider), "NORMAL", "SummaryRow");
            configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, (Object)new AverageSummaryProvider(), "NORMAL", "SummaryColumn_4");
        }

        class AverageSummaryProvider
        implements ISummaryProvider {
            AverageSummaryProvider() {
            }

            public Object summarize(int columnIndex) {
                double total = 0.0;
                int rowCount = ExampleSummaryRowConfiguration.this.dataProvider.getRowCount();
                int rowIndex = 0;
                while (rowIndex < rowCount) {
                    Object dataValue = ExampleSummaryRowConfiguration.this.dataProvider.getDataValue(columnIndex, rowIndex);
                    total += Double.parseDouble(dataValue.toString());
                    ++rowIndex;
                }
                return "Avg: " + total / (double)rowCount;
            }
        }
    }
}

