/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._504_Viewport;

import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.print.command.MultiTurnViewportOffCommandHandler;
import org.eclipse.nebula.widgets.nattable.print.command.MultiTurnViewportOnCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.action.ColumnReorderDragMode;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayerPainter;
import org.eclipse.nebula.widgets.nattable.ui.action.AggregateDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.CellDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.util.ClientAreaAdapter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.nebula.widgets.nattable.viewport.IScroller;
import org.eclipse.nebula.widgets.nattable.viewport.SliderScroller;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;

public class _5044_HorizontalSplitViewportGridExample
extends AbstractNatExample {
    public static final int SPLIT_COLUMN_INDEX = 5;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5044_HorizontalSplitViewportGridExample());
    }

    @Override
    public String getDescription() {
        return "This example shows a NatTable that contains two separately scrollable horzizontal split viewports in a grid.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday", "address.street", "address.housenumber", "address.postalCode", "address.city"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        propertyToLabelMap.put("address.street", "Street");
        propertyToLabelMap.put("address.housenumber", "Housenumber");
        propertyToLabelMap.put("address.postalCode", "Postal Code");
        propertyToLabelMap.put("address.city", "City");
        ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
        final BodyLayerStack bodyLayer = new BodyLayerStack(PersonService.getPersonsWithAddress((int)50), columnPropertyAccessor);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayer.getBodyDataProvider());
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, bodyLayer, bodyLayer.getSelectionLayer());
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, bodyLayer, bodyLayer.getSelectionLayer());
        columnHeaderLayer.setLayerPainter((ILayerPainter)new CellLayerPainter((AbstractLayer)columnHeaderLayer, (DataLayer)columnHeaderDataLayer, bodyLayer, (ILayer)rowHeaderLayer){
            private final /* synthetic */ AbstractLayer val$columnHeaderLayer;
            private final /* synthetic */ DataLayer val$columnHeaderDataLayer;
            private final /* synthetic */ BodyLayerStack val$bodyLayer;
            private final /* synthetic */ ILayer val$rowHeaderLayer;
            {
                this.val$columnHeaderLayer = abstractLayer;
                this.val$columnHeaderDataLayer = dataLayer;
                this.val$bodyLayer = bodyLayerStack;
                this.val$rowHeaderLayer = iLayer;
            }

            protected boolean isClipLeft(int position) {
                int index = LayerUtil.convertColumnPosition((ILayer)this.val$columnHeaderLayer, (int)(position - 1), (IUniqueIndexLayer)this.val$columnHeaderDataLayer);
                return index > 5;
            }

            protected void paintCell(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
                ILayer layer = cell.getLayer();
                int columnPosition = cell.getColumnPosition();
                int rowPosition = cell.getRowPosition();
                ICellPainter cellPainter = layer.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
                Rectangle adjustedCellBounds = layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, cell.getBounds());
                if (cellPainter != null) {
                    Rectangle originalClipping = gc.getClipping();
                    int startX = this.getStartXOfColumnPosition(columnPosition);
                    int startY = this.getStartYOfRowPosition(rowPosition);
                    int endX = this.getStartXOfColumnPosition(cell.getOriginColumnPosition() + cell.getColumnSpan());
                    int endY = this.getStartYOfRowPosition(cell.getOriginRowPosition() + cell.getRowSpan());
                    int viewportBorderX = this.val$bodyLayer.getViewportLayerLeft().getClientAreaWidth() + this.val$rowHeaderLayer.getWidth();
                    if (this.isClipLeft(columnPosition) && startX < viewportBorderX) {
                        startX = viewportBorderX;
                    }
                    if (!this.isClipLeft(columnPosition - 1) && startX > viewportBorderX) {
                        startX = viewportBorderX;
                    }
                    if (this.isClipLeft(cell.getOriginColumnPosition() + cell.getColumnSpan()) && endX < viewportBorderX) {
                        endX = viewportBorderX;
                    }
                    Rectangle cellClipBounds = originalClipping.intersection(new Rectangle(startX, startY, endX - startX, endY - startY));
                    gc.setClipping(cellClipBounds.intersection(adjustedCellBounds));
                    cellPainter.paintCell(cell, gc, adjustedCellBounds, configRegistry);
                    gc.setClipping(originalClipping);
                }
            }
        });
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer(bodyLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        gridLayer.registerCommandHandler((ILayerCommandHandler)new MultiTurnViewportOnCommandHandler(new ViewportLayer[]{bodyLayer.getViewportLayerLeft(), bodyLayer.getViewportLayerRight()}));
        gridLayer.registerCommandHandler((ILayerCommandHandler)new MultiTurnViewportOffCommandHandler(new ViewportLayer[]{bodyLayer.getViewportLayerLeft(), bodyLayer.getViewportLayerRight()}));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        NatTable natTable = new NatTable(composite, (ILayer)gridLayer, false);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        natTable.setLayoutData((Object)gridData);
        this.createSplitSliders(composite, (ILayer)rowHeaderLayer, bodyLayer.getViewportLayerLeft(), bodyLayer.getViewportLayerRight());
        natTable.addOverlayPainter(new IOverlayPainter((ILayer)rowHeaderLayer){
            private final /* synthetic */ ILayer val$rowHeaderLayer;
            {
                this.val$rowHeaderLayer = iLayer;
            }

            public void paintOverlay(GC gc, ILayer layer) {
                Color beforeColor = gc.getForeground();
                gc.setForeground(GUIHelper.COLOR_GRAY);
                int viewportBorderX = bodyLayer.getViewportLayerLeft().getWidth() + this.val$rowHeaderLayer.getWidth() - 1;
                gc.drawLine(viewportBorderX, 0, viewportBorderX, layer.getHeight() - 1);
                gc.setForeground(beforeColor);
            }
        });
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable));
        natTable.configure();
        return composite;
    }

    private void createSplitSliders(Composite natTableParent, final ILayer rowHeaderLayer, final ViewportLayer left, ViewportLayer right) {
        Composite sliderComposite = new Composite(natTableParent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 17;
        sliderComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        sliderComposite.setLayout((Layout)gridLayout);
        Composite sliderLeftComposite = new Composite(sliderComposite, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                int width = ((ClientAreaAdapter)left.getClientAreaProvider()).getWidth();
                return new Point(width += rowHeaderLayer.getWidth(), 17);
            }
        };
        sliderLeftComposite.setLayout((Layout)new FillLayout());
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        sliderLeftComposite.setLayoutData((Object)gridData);
        Slider sliderLeft = new Slider(sliderLeftComposite, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        sliderLeft.setLayoutData((Object)gridData);
        left.setHorizontalScroller((IScroller)new SliderScroller(sliderLeft));
        Slider sliderRight = new Slider(sliderComposite, 256);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        sliderRight.setLayoutData((Object)gridData);
        right.setHorizontalScroller((IScroller)new SliderScroller(sliderRight));
    }

    class BodyLayerStack<T>
    extends AbstractLayerTransform {
        private final IDataProvider bodyDataProvider;
        private final ColumnHideShowLayer columnHideShowLayer;
        private final SelectionLayer selectionLayer;
        private final ViewportLayer viewportLayerLeft;
        private final ViewportLayer viewportLayerRight;

        public BodyLayerStack(List<T> values, IColumnPropertyAccessor<T> columnPropertyAccessor) {
            this.bodyDataProvider = new ListDataProvider(values, columnPropertyAccessor);
            DataLayer bodyDataLayer = new DataLayer(this.getBodyDataProvider());
            ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)bodyDataLayer, false);
            columnReorderLayer.addConfiguration((IConfiguration)new AbstractUiBindingConfiguration(){

                public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                    uiBindingRegistry.registerMouseDragMode((IMouseEventMatcher)MouseEventMatcher.columnHeaderLeftClick((int)0), (IDragMode)new AggregateDragMode(new IDragMode[]{new CellDragMode(), new SplitViewportColumnReorderDragMode()}));
                }
            });
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.columnHideShowLayer);
            this.selectionLayer.setLayerPainter((ILayerPainter)new SelectionLayerPainter(true, false));
            this.viewportLayerLeft = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer){

                public int getMaxColumnPosition() {
                    return BodyLayerStack.this.getNumberOfLeftColumns();
                }
            };
            this.viewportLayerRight = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer){

                public int getMinColumnPosition() {
                    return BodyLayerStack.this.getNumberOfLeftColumns();
                }
            };
            int newMinOriginX = this.selectionLayer.getStartXOfColumnPosition(this.getNumberOfLeftColumns());
            this.viewportLayerRight.setMinimumOriginX(newMinOriginX);
            CompositeLayer compositeLayer = new CompositeLayer(2, 1);
            compositeLayer.setChildLayer("REGION_A", (ILayer)this.getViewportLayerLeft(), 0, 0);
            compositeLayer.setChildLayer("REGION_B", (ILayer)this.getViewportLayerRight(), 1, 0);
            int leftWidth = bodyDataLayer.getStartXOfColumnPosition(2);
            ClientAreaAdapter leftClientAreaAdapter = new ClientAreaAdapter(this.getViewportLayerLeft().getClientAreaProvider());
            leftClientAreaAdapter.setWidth(leftWidth);
            this.getViewportLayerLeft().setClientAreaProvider((IClientAreaProvider)leftClientAreaAdapter);
            this.registerCommandHandler((ILayerCommandHandler)new SplitViewportColumnReorderCommandHandler(this.getViewportLayerLeft()));
            this.setUnderlyingLayer((ILayer)compositeLayer);
        }

        private int getNumberOfLeftColumns() {
            int fixedColumns = 5;
            int i = 0;
            while (i < 5) {
                if (this.columnHideShowLayer.isColumnIndexHidden(i)) {
                    --fixedColumns;
                }
                ++i;
            }
            return fixedColumns;
        }

        public IDataProvider getBodyDataProvider() {
            return this.bodyDataProvider;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }

        public ViewportLayer getViewportLayerLeft() {
            return this.viewportLayerLeft;
        }

        public ViewportLayer getViewportLayerRight() {
            return this.viewportLayerRight;
        }
    }

    class SplitViewportColumnReorderCommandHandler
    extends AbstractLayerCommandHandler<ColumnReorderCommand> {
        private ViewportLayer viewportLeft;

        public SplitViewportColumnReorderCommandHandler(ViewportLayer viewportLeft) {
            this.viewportLeft = viewportLeft;
        }

        protected boolean doCommand(ColumnReorderCommand command) {
            return command.getFromColumnPosition() < this.viewportLeft.getColumnCount() != command.getToColumnPosition() < this.viewportLeft.getColumnCount();
        }

        public Class<ColumnReorderCommand> getCommandClass() {
            return ColumnReorderCommand.class;
        }
    }

    class SplitViewportColumnReorderDragMode
    extends ColumnReorderDragMode {
        SplitViewportColumnReorderDragMode() {
        }

        protected boolean isValidTargetColumnPosition(ILayer natLayer, int dragFromGridColumnPosition, int dragToGridColumnPosition) {
            if (((NatTable)natLayer).getCursor() == null) {
                int fromColumnIndex = natLayer.getColumnIndexByPosition(dragFromGridColumnPosition);
                int toColumnIndex = natLayer.getColumnIndexByPosition(dragToGridColumnPosition);
                if (fromColumnIndex < 5 && toColumnIndex < 5 || fromColumnIndex >= 5 && toColumnIndex >= 5) {
                    return super.isValidTargetColumnPosition(natLayer, dragFromGridColumnPosition, dragToGridColumnPosition);
                }
            }
            return false;
        }
    }
}

