/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._400_Configuration;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.EditableRule;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.MarkupDisplayConverter;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RichTextCellEditor;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RichTextCellPainter;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultGridLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _424_NebulaRichTextIntegrationExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(800, 600, new _424_NebulaRichTextIntegrationExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the integration of the Nebula Rich Text Control.\nThe RichTextCellPainter is configured for the lastname and the description columns. While the lastname column also has a MarkupDisplayConverter that renders 'Simpson' and 'Smithers' differently, the description column also has the RichTextCellEditor configured, to be free to enter content with HTML markups.\n\nNOTE: Because the rich text control resources need to be unpacked when deployed in a JAR,the first time opening the description cell editor takes some more time.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        System.setProperty("org.eclipse.nebula.widgets.richtext.jar.unpackdir", String.valueOf(System.getProperty("user.dir")) + File.separator + RichTextEditor.class.getPackage().getName());
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "description"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("description", "Description");
        ReflectiveColumnPropertyAccessor columnAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        List persons = PersonService.getPersons((int)10);
        ListDataProvider bodyDataProvider = new ListDataProvider(persons, (IColumnAccessor)columnAccessor);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultGridLayer gridLayer = new DefaultGridLayer((IDataProvider)bodyDataProvider, (IDataProvider)columnHeaderDataProvider);
        ((AbstractLayer)gridLayer.getBodyDataLayer()).setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                MarkupDisplayConverter markupConverter = new MarkupDisplayConverter();
                markupConverter.registerMarkup("Simpson", "<em>", "</em>");
                markupConverter.registerMarkup("Smithers", "<span style=\"background-color:rgb(255, 0, 0)\"><strong><s><u>", "</u></s></strong></span>");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)markupConverter, "NORMAL", "COLUMN_1");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDisplayConverter(), "EDIT", "COLUMN_1");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", "COLUMN_3");
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new BackgroundPainter((ICellPainter)new PaddingDecorator((ICellPainter)new RichTextCellPainter(), 2, 5, 2, 5)), "NORMAL", "COLUMN_1");
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", "COLUMN_3");
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new BackgroundPainter((ICellPainter)new PaddingDecorator((ICellPainter)new RichTextCellPainter(), 2, 5, 2, 5)), "NORMAL", "COLUMN_4");
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)EditableRule.ALWAYS_EDITABLE);
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(), "NORMAL", "COLUMN_3");
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new RichTextCellEditor(), "NORMAL", "COLUMN_4");
            }
        });
        natTable.configure();
        natTable.setTheme((ThemeConfiguration)new ModernNatTableThemeConfiguration());
        return natTable;
    }
}

