/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._300_Data;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.dataset.person.DataModelConstants;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonWithAddress;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _302_CustomColumnPropertyAccessorExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _302_CustomColumnPropertyAccessorExample());
    }

    @Override
    public String getDescription() {
        return "This is an example to show how to implement a custom IColumnPropertyAccessor.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        PersonWithAddressColumnPropertyAccessor columnPropertyAccessor = new PersonWithAddressColumnPropertyAccessor();
        ListDataProvider bodyDataProvider = new ListDataProvider(PersonService.getPersonsWithAddress((int)10), (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer(this.createColumnHeaderDataProvider()), (ILayer)viewportLayer, selectionLayer);
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        return new NatTable(parent, (ILayer)compositeLayer);
    }

    protected IDataProvider createColumnHeaderDataProvider() {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday", "street", "housenumber", "postalCode", "city"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        propertyToLabelMap.put("street", "Street");
        propertyToLabelMap.put("housenumber", "Housenumber");
        propertyToLabelMap.put("postalCode", "Postal Code");
        propertyToLabelMap.put("city", "City");
        return new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
    }

    class PersonWithAddressColumnPropertyAccessor
    implements IColumnPropertyAccessor<PersonWithAddress> {
        PersonWithAddressColumnPropertyAccessor() {
        }

        public Object getDataValue(PersonWithAddress rowObject, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return rowObject.getFirstName();
                }
                case 1: {
                    return rowObject.getLastName();
                }
                case 2: {
                    return rowObject.getGender();
                }
                case 3: {
                    return rowObject.isMarried();
                }
                case 4: {
                    return rowObject.getBirthday();
                }
                case 5: {
                    return rowObject.getAddress().getStreet();
                }
                case 6: {
                    return rowObject.getAddress().getHousenumber();
                }
                case 7: {
                    return rowObject.getAddress().getPostalCode();
                }
                case 8: {
                    return rowObject.getAddress().getCity();
                }
            }
            return "";
        }

        public void setDataValue(PersonWithAddress rowObject, int columnIndex, Object newValue) {
            switch (columnIndex) {
                case 0: {
                    rowObject.setFirstName((String)newValue);
                    break;
                }
                case 1: {
                    rowObject.setLastName((String)newValue);
                    break;
                }
                case 2: {
                    rowObject.setGender((Person.Gender)newValue);
                    break;
                }
                case 3: {
                    rowObject.setMarried(((Boolean)newValue).booleanValue());
                    break;
                }
                case 4: {
                    rowObject.setBirthday((Date)newValue);
                    break;
                }
                case 5: {
                    rowObject.getAddress().setStreet((String)newValue);
                    break;
                }
                case 6: {
                    rowObject.getAddress().setHousenumber(((Integer)newValue).intValue());
                    break;
                }
                case 7: {
                    rowObject.getAddress().setPostalCode(((Integer)newValue).intValue());
                    break;
                }
                case 8: {
                    rowObject.getAddress().setCity((String)newValue);
                }
            }
        }

        public int getColumnCount() {
            return 9;
        }

        public String getColumnProperty(int columnIndex) {
            return DataModelConstants.PERSONWITHADDRESS_PROPERTY_NAMES[columnIndex];
        }

        public int getColumnIndex(String propertyName) {
            return Arrays.asList(DataModelConstants.PERSONWITHADDRESS_PROPERTY_NAMES).indexOf(propertyName);
        }
    }
}

