/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.poi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.nebula.widgets.nattable.extension.poi.ExcelCellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;

public abstract class PoiExcelExporter
implements ILayerExporter {
    private final IOutputStreamProvider outputStreamProvider;
    private Map<ExcelCellStyleAttributes, CellStyle> xlCellStyles;
    protected Workbook xlWorkbook;
    protected int sheetNumber;
    protected Sheet xlSheet;
    protected Row xlRow;

    public PoiExcelExporter(IOutputStreamProvider outputStreamProvider) {
        this.outputStreamProvider = outputStreamProvider;
    }

    public OutputStream getOutputStream(Shell shell) {
        return this.outputStreamProvider.getOutputStream(shell);
    }

    public void exportBegin(OutputStream outputStream) throws IOException {
        this.xlCellStyles = new HashMap<ExcelCellStyleAttributes, CellStyle>();
        this.xlWorkbook = this.createWorkbook();
    }

    public void exportEnd(OutputStream outputStream) throws IOException {
        this.xlWorkbook.write(outputStream);
        this.xlCellStyles = null;
        this.xlWorkbook = null;
        this.sheetNumber = 0;
        this.xlSheet = null;
        this.xlRow = null;
    }

    public void exportLayerBegin(OutputStream outputStream, String layerName) throws IOException {
        ++this.sheetNumber;
        if (layerName == null || layerName.length() == 0) {
            layerName = "Sheet" + this.sheetNumber;
        }
        this.xlSheet = this.xlWorkbook.createSheet(layerName);
    }

    public void exportLayerEnd(OutputStream outputStream, String layerName) throws IOException {
    }

    public void exportRowBegin(OutputStream outputStream, int rowPosition) throws IOException {
        this.xlRow = this.xlSheet.createRow(rowPosition);
    }

    public void exportRowEnd(OutputStream outputStream, int rowPosition) throws IOException {
    }

    public void exportCell(OutputStream outputStream, Object exportDisplayValue, ILayerCell cell, IConfigRegistry configRegistry) throws IOException {
        int columnPosition = cell.getColumnPosition();
        int rowPosition = cell.getRowPosition();
        if (columnPosition != cell.getOriginColumnPosition() || rowPosition != cell.getOriginRowPosition()) {
            return;
        }
        Cell xlCell = this.xlRow.createCell(columnPosition);
        int columnSpan = cell.getColumnSpan();
        int rowSpan = cell.getRowSpan();
        if (columnSpan > 1 || rowSpan > 1) {
            int lastRow = rowPosition + rowSpan - 1;
            int lastColumn = columnPosition + columnSpan - 1;
            this.xlSheet.addMergedRegion(new CellRangeAddress(rowPosition, lastRow, columnPosition, lastColumn));
        }
        CellStyleProxy cellStyle = new CellStyleProxy(configRegistry, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        Color fg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR);
        Color bg = (Color)cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
        org.eclipse.swt.graphics.Font font = (org.eclipse.swt.graphics.Font)cellStyle.getAttributeValue(CellStyleAttributes.FONT);
        FontData fontData = font.getFontData()[0];
        xlCell.setCellStyle(this.getExcelCellStyle(fg, bg, fontData));
        if (exportDisplayValue == null) {
            exportDisplayValue = "";
        }
        if (exportDisplayValue instanceof Boolean) {
            xlCell.setCellValue(((Boolean)exportDisplayValue).booleanValue());
        } else if (exportDisplayValue instanceof Calendar) {
            xlCell.setCellValue((Calendar)exportDisplayValue);
        } else if (exportDisplayValue instanceof Date) {
            xlCell.setCellValue((Date)exportDisplayValue);
        } else if (exportDisplayValue instanceof Number) {
            xlCell.setCellValue(((Number)exportDisplayValue).doubleValue());
        } else {
            xlCell.setCellValue(exportDisplayValue.toString());
        }
    }

    private CellStyle getExcelCellStyle(Color fg, Color bg, FontData fontData) {
        CellStyle xlCellStyle = this.xlCellStyles.get(new ExcelCellStyleAttributes(fg, bg, fontData));
        if (xlCellStyle == null) {
            xlCellStyle = this.xlWorkbook.createCellStyle();
            this.setFillForegroundColor(xlCellStyle, bg);
            xlCellStyle.setFillPattern((short)1);
            Font xlFont = this.xlWorkbook.createFont();
            this.setFontColor(xlFont, fg);
            xlFont.setFontName(fontData.getName());
            xlFont.setFontHeightInPoints((short)fontData.getHeight());
            xlCellStyle.setFont(xlFont);
            this.xlCellStyles.put(new ExcelCellStyleAttributes(fg, bg, fontData), xlCellStyle);
        }
        return xlCellStyle;
    }

    protected abstract Workbook createWorkbook();

    protected abstract void setFillForegroundColor(CellStyle var1, Color var2);

    protected abstract void setFontColor(Font var1, Color var2);
}

