/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree;

import ca.odell.glazedlists.TreeList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlazedListTreeData<T>
implements ITreeData<T> {
    private TreeList<T> treeList;

    public GlazedListTreeData(TreeList<T> treeList) {
        this.setTreeList(treeList);
    }

    public void setTreeList(TreeList<T> treeList) {
        this.treeList = treeList;
    }

    public String formatDataForDepth(int depth, int index) {
        return this.formatDataForDepth(depth, this.treeList.get(index));
    }

    public String formatDataForDepth(int depth, T object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public T getDataAtIndex(int index) {
        return (T)this.treeList.get(index);
    }

    public int getDepthOfData(T object) {
        return this.getDepthOfData(this.indexOf(object));
    }

    public int getDepthOfData(int index) {
        return this.treeList.depth(index);
    }

    public int indexOf(T object) {
        return this.treeList.indexOf(object);
    }

    public boolean hasChildren(T object) {
        return this.hasChildren(this.indexOf(object));
    }

    public boolean hasChildren(int index) {
        return this.treeList.hasChildren(index);
    }

    public List<T> getChildren(T object) {
        return this.getChildren(this.indexOf(object));
    }

    public List<T> getChildren(int index) {
        List childrenNodes = this.treeList.getTreeNode(index).getChildren();
        ArrayList<Object> children = new ArrayList<Object>();
        for (TreeList.Node node : childrenNodes) {
            children.add(node.getElement());
        }
        return children;
    }

    public void collapse(T object) {
        this.collapse(this.indexOf(object));
    }

    public void expand(T object) {
        this.expand(this.indexOf(object));
    }

    public void collapse(int index) {
        this.toggleExpanded(index, false);
    }

    public void expand(int index) {
        this.toggleExpanded(index, true);
    }

    private void toggleExpanded(int index, boolean expanded) {
        this.treeList.setExpanded(index, expanded);
    }

    public boolean isExpanded(T object) {
        return this.isExpanded(this.indexOf(object));
    }

    public boolean isExpanded(int index) {
        return this.treeList.isExpanded(index);
    }
}

