/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy;

import ca.odell.glazedlists.TreeList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByTreeFormat<T>
implements TreeList.Format<Object> {
    private final GroupByModel model;
    private final IColumnAccessor<T> columnAccessor;

    public GroupByTreeFormat(GroupByModel model, IColumnAccessor<T> columnAccessor) {
        this.model = model;
        this.columnAccessor = columnAccessor;
    }

    public void getPath(List<Object> path, Object element) {
        for (int columnIndex : this.model.getGroupByColumnIndexes()) {
            Object columnValue = this.columnAccessor.getDataValue(element, columnIndex);
            path.add(new GroupByObject(columnValue));
        }
        path.add(element);
    }

    public boolean allowsChildren(Object element) {
        return true;
    }

    public Comparator<Object> getComparator(int depth) {
        return DefaultComparator.getInstance();
    }
}

