/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree.painter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.painter.TreeImagePainter;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndentedTreeImagePainter
extends CellPainterWrapper {
    private final ITreeRowModel<?> treeRowModel;
    private final int treeIndent;

    public IndentedTreeImagePainter(ITreeRowModel<?> treeRowModel) {
        this(treeRowModel, 10, new TreeImagePainter(treeRowModel));
    }

    public IndentedTreeImagePainter(ITreeRowModel<?> treeRowModel, int treeIndent, ICellPainter treeImagePainter) {
        this.treeRowModel = treeRowModel;
        this.treeIndent = treeIndent;
        this.setWrappedPainter(treeImagePainter);
    }

    public ICellPainter getTreeImagePainter() {
        return this.getWrappedPainter();
    }

    @Override
    public Rectangle getWrappedPainterBounds(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        int depth = this.getDepth(cell);
        int indent = this.getIndent(depth);
        return new Rectangle(bounds.x + indent, bounds.y, bounds.width - indent, bounds.height);
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
        super.paintCell(cell, gc, this.getWrappedPainterBounds(cell, gc, bounds, configRegistry), configRegistry);
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        int depth = this.getDepth(cell);
        int indent = this.getIndent(depth);
        return indent + super.getPreferredWidth(cell, gc, configRegistry);
    }

    protected int getIndent(int depth) {
        return this.treeIndent * depth;
    }

    private int getDepth(ILayerCell cell) {
        int index = cell.getLayer().getRowIndexByPosition(cell.getRowPosition());
        return this.treeRowModel.depth(index);
    }
}

