/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.summaryrow;

import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class DefaultSummaryRowConfiguration
extends AbstractRegistryConfiguration {
    public BorderStyle summaryRowBorderStyle = new BorderStyle(0, GUIHelper.COLOR_BLACK, BorderStyle.LineStyleEnum.DOTTED);
    public Color summaryRowFgColor = GUIHelper.COLOR_BLACK;
    public Color summaryRowBgColor = GUIHelper.COLOR_WHITE;
    public Font summaryRowFont = GUIHelper.getFont(new FontData("Verdana", 8, 1));

    public void configureRegistry(IConfigRegistry configRegistry) {
        this.addSummaryRowStyleConfig(configRegistry);
        this.addSummaryProviderConfig(configRegistry);
        this.addSummaryRowDisplayConverter(configRegistry);
    }

    protected void addSummaryRowStyleConfig(IConfigRegistry configRegistry) {
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.summaryRowFont);
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.summaryRowBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.summaryRowFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.summaryRowBorderStyle);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, "NORMAL", "SummaryRow");
    }

    protected void addSummaryProviderConfig(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, ISummaryProvider.DEFAULT, "NORMAL", "SummaryRow");
    }

    protected void addSummaryRowDisplayConverter(IConfigRegistry configRegistry) {
        DefaultDisplayConverter converter = new DefaultDisplayConverter(){

            public Object canonicalToDisplayValue(Object canonicalValue) {
                if (canonicalValue == null) {
                    return ISummaryProvider.DEFAULT_SUMMARY_VALUE;
                }
                return super.canonicalToDisplayValue(canonicalValue);
            }
        };
        configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, converter, "NORMAL", "SummaryRow");
    }
}

