/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupExpandCollapseLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.command.ColumnGroupExpandCollapseCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnGroupExpandCollapseCommandHandler
extends AbstractLayerCommandHandler<ColumnGroupExpandCollapseCommand> {
    private final ColumnGroupExpandCollapseLayer columnGroupExpandCollapseLayer;

    public ColumnGroupExpandCollapseCommandHandler(ColumnGroupExpandCollapseLayer columnGroupExpandCollapseLayer) {
        this.columnGroupExpandCollapseLayer = columnGroupExpandCollapseLayer;
    }

    @Override
    public Class<ColumnGroupExpandCollapseCommand> getCommandClass() {
        return ColumnGroupExpandCollapseCommand.class;
    }

    @Override
    protected boolean doCommand(ColumnGroupExpandCollapseCommand command) {
        int columnIndex = this.columnGroupExpandCollapseLayer.getColumnIndexByPosition(command.getColumnPosition());
        ColumnGroupModel model = this.columnGroupExpandCollapseLayer.getModel();
        ColumnGroupModel.ColumnGroup columnGroup = model.getColumnGroupByIndex(columnIndex);
        if (!columnGroup.isCollapseable()) {
            return true;
        }
        boolean wasCollapsed = columnGroup.isCollapsed();
        columnGroup.toggleCollapsed();
        ArrayList<Integer> columnPositions = new ArrayList<Integer>(columnGroup.getMembers());
        columnPositions.removeAll(columnGroup.getStaticColumnIndexes());
        ColumnStructuralChangeEvent event = wasCollapsed ? new ShowColumnPositionsEvent(this.columnGroupExpandCollapseLayer, columnPositions) : new HideColumnPositionsEvent((ILayer)this.columnGroupExpandCollapseLayer, (Collection<Integer>)columnPositions);
        this.columnGroupExpandCollapseLayer.fireLayerEvent(event);
        return true;
    }
}

