/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.grid.layer;

import org.eclipse.nebula.widgets.nattable.grid.layer.DimensionallyDependentLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultRowHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class RowHeaderLayer
extends DimensionallyDependentLayer {
    private final SelectionLayer selectionLayer;

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer selectionLayer) {
        this(baseLayer, verticalLayerDependency, selectionLayer, true);
    }

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer selectionLayer, boolean useDefaultConfiguration) {
        this(baseLayer, verticalLayerDependency, selectionLayer, useDefaultConfiguration, null);
    }

    public RowHeaderLayer(IUniqueIndexLayer baseLayer, ILayer verticalLayerDependency, SelectionLayer selectionLayer, boolean useDefaultConfiguration, ILayerPainter layerPainter) {
        super(baseLayer, baseLayer, verticalLayerDependency);
        if (selectionLayer == null) {
            throw new NullPointerException("selectionLayer");
        }
        this.selectionLayer = selectionLayer;
        this.layerPainter = layerPainter;
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultRowHeaderLayerConfiguration());
        }
    }

    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        int selectionLayerRowPosition = LayerUtil.convertRowPosition(this, rowPosition, this.selectionLayer);
        if (this.selectionLayer.isRowPositionSelected(selectionLayerRowPosition)) {
            return "SELECT";
        }
        return super.getDisplayModeByPosition(columnPosition, rowPosition);
    }

    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        LabelStack labelStack = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        int selectionLayerRowPosition = LayerUtil.convertRowPosition(this, rowPosition, this.selectionLayer);
        if (this.selectionLayer.isRowPositionFullySelected(selectionLayerRowPosition)) {
            labelStack.addLabel("ROW_HEADER_FULL");
        }
        return labelStack;
    }
}

