/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.event.FreezeEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;

public class FreezeLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private PositionCoordinate topLeftPosition = new PositionCoordinate(this, -1, -1);
    private PositionCoordinate bottomRightPosition = new PositionCoordinate(this, -1, -1);

    public FreezeLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.registerEventHandler(new FreezeEventHandler(this));
    }

    public boolean isFrozen() {
        return this.getColumnCount() > 0 || this.getRowCount() > 0;
    }

    public PositionCoordinate getTopLeftPosition() {
        return this.topLeftPosition;
    }

    public void setTopLeftPosition(int leftColumnPosition, int topRowPosition) {
        this.topLeftPosition = new PositionCoordinate(this, leftColumnPosition, topRowPosition);
    }

    public PositionCoordinate getBottomRightPosition() {
        return this.bottomRightPosition;
    }

    public void setBottomRightPosition(int rightColumnPosition, int bottomRowPosition) {
        this.bottomRightPosition = new PositionCoordinate(this, rightColumnPosition, bottomRowPosition);
    }

    public int getColumnCount() {
        if (this.topLeftPosition.columnPosition >= 0 && this.bottomRightPosition.columnPosition >= 0) {
            return this.bottomRightPosition.columnPosition - this.topLeftPosition.columnPosition + 1;
        }
        return 0;
    }

    public int getPreferredColumnCount() {
        return this.getColumnCount();
    }

    public int getColumnPositionByIndex(int columnIndex) {
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        return this.underlyingToLocalColumnPosition(underlyingLayer, underlyingLayer.getColumnPositionByIndex(columnIndex));
    }

    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return this.topLeftPosition.columnPosition + localColumnPosition;
    }

    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        return underlyingColumnPosition - this.topLeftPosition.columnPosition;
    }

    public int getWidth() {
        int width = 0;
        int columnPosition = 0;
        while (columnPosition < this.getColumnCount()) {
            width += this.getColumnWidthByPosition(columnPosition);
            ++columnPosition;
        }
        return width;
    }

    public int getPreferredWidth() {
        return this.getWidth();
    }

    public int getColumnPositionByX(int x) {
        int xOffset = this.underlyingLayer.getStartXOfColumnPosition(this.topLeftPosition.columnPosition);
        return this.underlyingToLocalColumnPosition(this.underlyingLayer, this.underlyingLayer.getColumnPositionByX(xOffset + x));
    }

    public int getStartXOfColumnPosition(int columnPosition) {
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, underlyingLayer);
        return underlyingLayer.getStartXOfColumnPosition(underlyingColumnPosition) - underlyingLayer.getStartXOfColumnPosition(this.topLeftPosition.columnPosition);
    }

    public int getRowCount() {
        if (this.topLeftPosition.rowPosition >= 0 && this.bottomRightPosition.rowPosition >= 0) {
            int frozenRowCount = this.bottomRightPosition.rowPosition - this.topLeftPosition.rowPosition + 1;
            int underlyingRowCount = this.getUnderlyingLayer().getRowCount();
            return frozenRowCount <= underlyingRowCount ? frozenRowCount : 0;
        }
        return 0;
    }

    public int getPreferredRowCount() {
        return this.getRowCount();
    }

    public int getRowPositionByIndex(int rowIndex) {
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        return this.underlyingToLocalRowPosition(underlyingLayer, underlyingLayer.getRowPositionByIndex(rowIndex));
    }

    public int localToUnderlyingRowPosition(int localRowPosition) {
        return this.topLeftPosition.rowPosition + localRowPosition;
    }

    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        return underlyingRowPosition - this.topLeftPosition.rowPosition;
    }

    public int getHeight() {
        int height = 0;
        int rowPosition = 0;
        while (rowPosition < this.getRowCount()) {
            height += this.getRowHeightByPosition(rowPosition);
            ++rowPosition;
        }
        return height;
    }

    public int getPreferredHeight() {
        return this.getHeight();
    }

    public int getRowPositionByY(int y) {
        int yOffset = this.underlyingLayer.getStartYOfRowPosition(this.topLeftPosition.rowPosition);
        return this.underlyingToLocalRowPosition(this.underlyingLayer, this.underlyingLayer.getRowPositionByY(yOffset + y));
    }

    public int getStartYOfRowPosition(int rowPosition) {
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingRowPosition = LayerUtil.convertRowPosition(this, rowPosition, underlyingLayer);
        return underlyingLayer.getStartYOfRowPosition(underlyingRowPosition) - underlyingLayer.getStartYOfRowPosition(this.topLeftPosition.rowPosition);
    }
}

