/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.filterrow.event.FilterAppliedEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.nebula.widgets.nattable.util.PersistenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterRowDataProvider<T>
implements IDataProvider,
IPersistable {
    private final IFilterStrategy<T> filterStrategy;
    private final ILayer columnHeaderLayer;
    private final IDataProvider columnHeaderDataProvider;
    private final IConfigRegistry configRegistry;
    private Map<Integer, Object> filterObjectByIndex = new HashMap<Integer, Object>();
    private int rowCount = 1;

    public FilterRowDataProvider(IFilterStrategy<T> filterStrategy, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry) {
        this.filterStrategy = filterStrategy;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataProvider = columnHeaderDataProvider;
        this.configRegistry = configRegistry;
    }

    @Override
    public int getColumnCount() {
        return this.columnHeaderDataProvider.getColumnCount();
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        return this.filterObjectByIndex.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        columnIndex = this.columnHeaderLayer.getColumnIndexByPosition(columnIndex);
        if (ObjectUtils.isNotNull(newValue)) {
            this.filterObjectByIndex.put(columnIndex, newValue);
        } else {
            this.filterObjectByIndex.remove(columnIndex);
        }
        this.filterStrategy.applyFilter(this.filterObjectByIndex);
        this.columnHeaderLayer.fireLayerEvent(new FilterAppliedEvent(this.columnHeaderLayer));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        HashMap<Integer, String> filterTextByIndex = new HashMap<Integer, String>();
        for (Integer columnIndex : this.filterObjectByIndex.keySet()) {
            IDisplayConverter converter = this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, "NORMAL", "FILTER_COLUMN_" + columnIndex);
            filterTextByIndex.put(columnIndex, (String)converter.canonicalToDisplayValue(this.filterObjectByIndex.get(columnIndex)));
        }
        String string = PersistenceUtils.mapAsString(filterTextByIndex);
        if (!ObjectUtils.isEmpty(string)) {
            properties.put(String.valueOf(prefix) + ".filterTokens", string);
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.filterObjectByIndex.clear();
        try {
            Object property = properties.get(String.valueOf(prefix) + ".filterTokens");
            Map<Integer, String> filterTextByIndex = PersistenceUtils.parseString(property);
            for (Integer columnIndex : filterTextByIndex.keySet()) {
                IDisplayConverter converter = this.configRegistry.getConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, "NORMAL", "FILTER_COLUMN_" + columnIndex);
                this.filterObjectByIndex.put(columnIndex, converter.displayToCanonicalValue(filterTextByIndex.get(columnIndex)));
            }
        }
        catch (Exception e) {
            System.err.println("Error while restoring filter row text: " + e.getMessage());
        }
        this.filterStrategy.applyFilter(this.filterObjectByIndex);
    }

    public void clearAllFilters() {
        this.filterObjectByIndex.clear();
        this.filterStrategy.applyFilter(this.filterObjectByIndex);
    }
}

