/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.gui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.ActiveCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.EditTypeEnum;
import org.eclipse.nebula.widgets.nattable.edit.ICellEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MultiCellEditDialog
extends Dialog {
    private static final String SET = Messages.getString("MultiCellEditDialog.set");
    private static final String INCREASE_BY = Messages.getString("MultiCellEditDialog.increase");
    private static final String DECREASE_BY = Messages.getString("MultiCellEditDialog.decrease");
    private static final String ADJUST_BY = Messages.getString("MultiCellEditDialog.adjust");
    private static final String[] OPTIONS_DEFAULT = new String[]{SET, INCREASE_BY, DECREASE_BY};
    private static final String[] OPTIONS_ADJUST = new String[]{SET, ADJUST_BY};
    private final ICellEditor cellEditor;
    private final Object originalCanonicalValue;
    private final Character initialEditValue;
    private final boolean allowIncrementDecrement;
    private Combo updateCombo;
    private int lastSelectedIndex = 0;
    private Object editorValue;
    private boolean useAdjustBy;
    private IConfigRegistry configRegistry;
    private ILayerCell cell;

    public MultiCellEditDialog(Shell parentShell, ICellEditor cellEditor, Object originalCanonicalValue, Character initialEditValue, boolean allowIncrementDecrement, IConfigRegistry configRegistry, ILayerCell cell) {
        super(parentShell);
        this.setShellStyle(67696);
        this.cellEditor = cellEditor;
        this.originalCanonicalValue = originalCanonicalValue;
        this.initialEditValue = initialEditValue;
        this.allowIncrementDecrement = allowIncrementDecrement;
        this.configRegistry = configRegistry;
        this.cell = cell;
    }

    @Deprecated
    public MultiCellEditDialog(Shell parentShell, ICellEditor cellEditor, IDisplayConverter dataTypeConverter, IStyle cellStyle, IDataValidator dataValidator, Object originalCanonicalValue, Character initialEditValue, boolean allowIncrementDecrement) {
        super(parentShell);
        this.setShellStyle(67696);
        this.cellEditor = cellEditor;
        this.originalCanonicalValue = originalCanonicalValue;
        this.initialEditValue = initialEditValue;
        this.allowIncrementDecrement = allowIncrementDecrement;
    }

    public void setUseAdjustByOptionInsteadOfIncrementDecrement(boolean useAdjustBy) {
        this.useAdjustBy = useAdjustBy;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("MultiCellEditDialog.shellTitle"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        GridLayout panelLayout = new GridLayout(this.allowIncrementDecrement ? 2 : 1, false);
        panelLayout.marginWidth = 8;
        panel.setLayout((Layout)panelLayout);
        if (this.allowIncrementDecrement) {
            this.createUpdateCombo(panel);
        }
        ActiveCellEditor.close();
        ActiveCellEditor.activate(this.cellEditor, panel, this.originalCanonicalValue, this.initialEditValue, EditModeEnum.MULTI, new MultiEditHandler(), this.cell, this.configRegistry);
        Control editorControl = ActiveCellEditor.getControl();
        editorControl.addKeyListener(this.getEscKeyListener());
        GridDataFactory layoutData = GridDataFactory.fillDefaults().grab(true, false).hint(100, 20);
        if (this.allowIncrementDecrement) {
            layoutData.indent(5, 0);
        }
        layoutData.applyTo(editorControl);
        return panel;
    }

    private KeyListener getEscKeyListener() {
        return new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 27) {
                    this.closeDialog();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    this.closeDialog();
                }
            }

            private void closeDialog() {
                MultiCellEditDialog.this.setReturnCode(256);
                MultiCellEditDialog.this.close();
            }
        };
    }

    private void createUpdateCombo(Composite composite) {
        this.updateCombo = new Combo(composite, 2060);
        String[] stringArray = this.useAdjustBy ? OPTIONS_ADJUST : OPTIONS_DEFAULT;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String option = stringArray[n2];
            this.updateCombo.add(option);
            ++n2;
        }
        this.updateCombo.select(0);
        this.updateCombo.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MultiCellEditDialog.this.lastSelectedIndex = MultiCellEditDialog.this.updateCombo.getSelectionIndex();
            }
        });
        GridDataFactory.swtDefaults().applyTo((Control)this.updateCombo);
    }

    protected void okPressed() {
        if (ActiveCellEditor.isValid() && ActiveCellEditor.validateCanonicalValue()) {
            this.editorValue = ActiveCellEditor.getCanonicalValue();
            super.okPressed();
        }
    }

    public EditTypeEnum getEditType() {
        if (this.allowIncrementDecrement && this.updateCombo != null) {
            int selectionIndex;
            int n = selectionIndex = this.updateCombo.isDisposed() ? this.lastSelectedIndex : this.updateCombo.getSelectionIndex();
            if (this.useAdjustBy) {
                switch (selectionIndex) {
                    case 1: {
                        return EditTypeEnum.ADJUST;
                    }
                }
            } else {
                switch (selectionIndex) {
                    case 1: {
                        return EditTypeEnum.INCREASE;
                    }
                    case 2: {
                        return EditTypeEnum.DECREASE;
                    }
                }
            }
        }
        return EditTypeEnum.SET;
    }

    public Object getEditorValue() {
        return this.editorValue;
    }

    class MultiEditHandler
    implements ICellEditHandler {
        MultiEditHandler() {
        }

        public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
            if (direction == SelectionLayer.MoveDirectionEnum.NONE && closeAfterCommit) {
                MultiCellEditDialog.this.okPressed();
                return true;
            }
            return false;
        }
    }
}

