/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import org.eclipse.nebula.widgets.nattable.edit.ActiveCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CheckBoxCellEditor
extends AbstractCellEditor {
    private boolean checked;
    private Canvas canvas;

    protected Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue) {
        this.setCanonicalValue(originalCanonicalValue);
        this.checked = !this.checked;
        this.canvas = new Canvas(parent, 0);
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CheckBoxCellEditor.this.checked = !CheckBoxCellEditor.this.checked;
                CheckBoxCellEditor.this.canvas.redraw();
            }
        });
        this.commit(SelectionLayer.MoveDirectionEnum.NONE, false);
        if (this.editMode == EditModeEnum.INLINE && this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ActiveCellEditor.close();
                }
            });
        }
        return this.canvas;
    }

    public Object getCanonicalValue() {
        return this.getDataTypeConverter().displayToCanonicalValue(this.layerCell, this.configRegistry, this.checked);
    }

    public void setCanonicalValue(Object canonicalValue) {
        if (canonicalValue == null) {
            this.checked = false;
        } else {
            if (canonicalValue instanceof Boolean) {
                this.checked = (Boolean)canonicalValue;
            }
            Object convertedValue = null;
            if (this.getDataTypeConverter() != null) {
                convertedValue = this.getDataTypeConverter().canonicalToDisplayValue(this.layerCell, this.configRegistry, canonicalValue);
            }
            this.checked = convertedValue instanceof String ? Boolean.valueOf((String)convertedValue) : (convertedValue instanceof Boolean ? (Boolean)convertedValue : false);
        }
    }

    public void close() {
        super.close();
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
    }
}

