/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.editor;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.data.validate.ValidationFailedException;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.ICellEditHandler;
import org.eclipse.nebula.widgets.nattable.edit.config.LoggingErrorHandling;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleProxy;
import org.eclipse.nebula.widgets.nattable.style.ConfigAttribute;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCellEditor
implements ICellEditor {
    private boolean closed;
    private Composite parent;
    private ICellEditHandler editHandler;
    private IDisplayConverter displayConverter;
    private IStyle cellStyle;
    private IDataValidator dataValidator;
    protected EditModeEnum editMode;
    protected ILayerCell layerCell;
    protected IEditErrorHandler conversionEditErrorHandler;
    protected IEditErrorHandler validationEditErrorHandler;
    protected IConfigRegistry configRegistry;
    protected LabelStack labelStack;

    @Override
    public final Control activateCell(Composite parent, Object originalCanonicalValue, Character initialEditValue, EditModeEnum editMode, ICellEditHandler editHandler, ILayerCell cell, IConfigRegistry configRegistry) {
        this.closed = false;
        this.parent = parent;
        this.editHandler = editHandler;
        this.editMode = editMode;
        this.layerCell = cell;
        this.configRegistry = configRegistry;
        this.labelStack = cell.getConfigLabels();
        List<String> configLabels = this.labelStack.getLabels();
        this.displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "EDIT", configLabels);
        this.cellStyle = new CellStyleProxy(configRegistry, "EDIT", configLabels);
        this.dataValidator = configRegistry.getConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, "EDIT", configLabels);
        this.conversionEditErrorHandler = this.getEditErrorHandler(configRegistry, EditConfigAttributes.CONVERSION_ERROR_HANDLER, configLabels);
        this.validationEditErrorHandler = this.getEditErrorHandler(configRegistry, EditConfigAttributes.VALIDATION_ERROR_HANDLER, configLabels);
        return this.activateCell(parent, originalCanonicalValue, initialEditValue);
    }

    protected final int getColumnIndex() {
        return this.layerCell.getColumnIndex();
    }

    protected final int getRowIndex() {
        return this.layerCell.getRowIndex();
    }

    protected final int getColumnPosition() {
        return this.layerCell.getColumnPosition();
    }

    protected final int getRowPosition() {
        return this.layerCell.getRowPosition();
    }

    protected abstract Control activateCell(Composite var1, Object var2, Character var3);

    @Override
    public boolean validateCanonicalValue() {
        return this.validateCanonicalValue(this.conversionEditErrorHandler, this.validationEditErrorHandler);
    }

    @Override
    public boolean validateCanonicalValue(IEditErrorHandler conErrorHandler, IEditErrorHandler valErrorHandler) {
        Object canonicalValue;
        try {
            canonicalValue = this.getCanonicalValue();
            conErrorHandler.removeError(this);
        }
        catch (Exception e) {
            conErrorHandler.displayError(this, e);
            return false;
        }
        if (this.dataValidator != null) {
            try {
                boolean validationResult = this.dataValidator.validate(this.layerCell, this.configRegistry, canonicalValue);
                if (!validationResult) {
                    throw new ValidationFailedException(Messages.getString("AbstractCellEditor.validationFailure"));
                }
                valErrorHandler.removeError(this);
                return validationResult;
            }
            catch (Exception e) {
                valErrorHandler.displayError(this, e);
                return false;
            }
        }
        return true;
    }

    protected IDisplayConverter getDataTypeConverter() {
        return this.displayConverter;
    }

    protected IStyle getCellStyle() {
        return this.cellStyle;
    }

    protected IDataValidator getDataValidator() {
        return this.dataValidator;
    }

    protected final boolean commit(SelectionLayer.MoveDirectionEnum direction) {
        return this.commit(direction, true);
    }

    @Override
    public final boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
        if (this.editHandler != null && this.validateCanonicalValue()) {
            return this.editHandler.commit(direction, closeAfterCommit);
        }
        return false;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.forceFocus();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private IEditErrorHandler getEditErrorHandler(IConfigRegistry configRegistry, ConfigAttribute<IEditErrorHandler> configAttribute, List<String> configLabels) {
        IEditErrorHandler errorHandler = configRegistry.getConfigAttribute(configAttribute, "EDIT", configLabels);
        if (errorHandler == null) {
            errorHandler = new LoggingErrorHandling();
        }
        return errorHandler;
    }
}

