/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data;

import java.lang.reflect.Method;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedReflectiveColumnPropertyAccessor<R>
extends ReflectiveColumnPropertyAccessor<R> {
    public ExtendedReflectiveColumnPropertyAccessor(String[] propertyNames) {
        super(propertyNames);
    }

    @Override
    public Object getDataValue(R rowObj, int columnIndex) {
        String propertyName = this.getColumnProperty(columnIndex);
        if (propertyName.contains(".")) {
            return this.getPropertyValue(rowObj, propertyName);
        }
        return super.getDataValue(rowObj, columnIndex);
    }

    @Override
    public void setDataValue(R rowObj, int columnIndex, Object newValue) {
        String propertyName = this.getColumnProperty(columnIndex);
        if (propertyName.contains(".")) {
            this.setPropertyValue(rowObj, propertyName, newValue);
        } else {
            super.setDataValue(rowObj, columnIndex, newValue);
        }
    }

    private Object getPropertyValue(Object object, String propertyName) {
        assert (object != null) : "object can not be null!";
        String[] propertyChain = null;
        propertyChain = propertyName.contains(".") ? propertyName.split("\\.") : new String[]{propertyName};
        Object child = object;
        Class<?> objectClass = object.getClass();
        String getterName = null;
        Method getterMethod = null;
        String[] stringArray = propertyChain;
        int n = propertyChain.length;
        int n2 = 0;
        while (n2 < n) {
            String pc = stringArray[n2];
            getterName = "get" + pc.substring(0, 1).toUpperCase() + pc.substring(1);
            try {
                getterMethod = objectClass.getMethod(getterName, new Class[0]);
                child = getterMethod.invoke(child, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    getterName = "is" + pc.substring(0, 1).toUpperCase() + pc.substring(1);
                    getterMethod = objectClass.getMethod(getterName, new Class[0]);
                    child = getterMethod.invoke(child, new Object[0]);
                }
                catch (Exception exception) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            if (child == null) break;
            objectClass = child.getClass();
            ++n2;
        }
        return child;
    }

    private void setPropertyValue(Object object, String propertyName, Object value) {
        assert (object != null) : "object can not be null!";
        try {
            Object singlePropertyObject = null;
            String singlePropertyName = null;
            if (propertyName.contains(".")) {
                singlePropertyObject = this.getPropertyValue(object, propertyName.substring(0, propertyName.lastIndexOf(".")));
                singlePropertyName = propertyName.substring(propertyName.lastIndexOf(".") + 1);
            } else {
                singlePropertyObject = object;
                singlePropertyName = propertyName;
            }
            String setterName = "set" + singlePropertyName.substring(0, 1).toUpperCase() + singlePropertyName.substring(1);
            Method setterMethod = null;
            if (value != null) {
                setterMethod = singlePropertyObject.getClass().getMethod(setterName, value.getClass());
            } else {
                Method[] methods;
                Method[] methodArray = methods = singlePropertyObject.getClass().getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    if (m.getName().equals(setterName)) {
                        setterMethod = m;
                    }
                    ++n2;
                }
            }
            setterMethod.invoke(singlePropertyObject, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

