/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public abstract class AbstractColumnCommand
implements ILayerCommand {
    private ColumnPositionCoordinate columnPositionCoordinate;

    protected AbstractColumnCommand(ILayer layer, int columnPosition) {
        this.columnPositionCoordinate = new ColumnPositionCoordinate(layer, columnPosition);
    }

    protected AbstractColumnCommand(AbstractColumnCommand command) {
        this.columnPositionCoordinate = command.columnPositionCoordinate;
    }

    public boolean convertToTargetLayer(ILayer targetLayer) {
        this.columnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(this.columnPositionCoordinate, targetLayer);
        return this.columnPositionCoordinate != null;
    }

    public ILayer getLayer() {
        return this.columnPositionCoordinate.getLayer();
    }

    public int getColumnPosition() {
        return this.columnPositionCoordinate.getColumnPosition();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " columnPosition=" + this.columnPositionCoordinate.getColumnPosition();
    }
}

