/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.planner;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.compatibility.CommonFonts;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskActivityManager;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TaskActivityLabelProvider
extends TaskElementLabelProvider
implements ITableLabelProvider,
IColorProvider,
IFontProvider {
    private static final String UNITS_HOURS = " hours";
    private static final String NO_MINUTES = "0 minutes";
    private final ITaskActivityManager activityManager;
    private Color categoryBackgroundColor;
    private final ITreeContentProvider contentProvider;

    public TaskActivityLabelProvider(ILabelProvider provider, ILabelDecorator decorator, Color parentBacground, ITreeContentProvider contentProvider) {
        super(true);
        this.categoryBackgroundColor = parentBacground;
        this.activityManager = TasksUiPlugin.getTaskActivityManager();
        this.contentProvider = contentProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (!(element instanceof ScheduledTaskContainer)) return super.getImage(element);
            super.getImage(element);
            return null;
        } else {
            if (columnIndex != 1 || !(element instanceof ITask)) return null;
            ITask taskElement = (ITask)element;
            return TasksUiImages.getImageForPriority((ITask.PriorityLevel)ITask.PriorityLevel.fromString((String)taskElement.getPriority()));
        }
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ITask) {
            AbstractTask task = (AbstractTask)element;
            switch (columnIndex) {
                case 2: {
                    if (task != null) {
                        return task.getSummary();
                    }
                }
                case 3: {
                    ScheduledTaskContainer container = (ScheduledTaskContainer)this.contentProvider.getParent((Object)task);
                    if (container != null) {
                        return DateUtil.getFormattedDurationShort((long)this.activityManager.getElapsedTime((ITask)task, container.getDateRange().getStartDate(), container.getDateRange().getEndDate()));
                    }
                    return "na";
                }
                case 4: {
                    return String.valueOf(task.getEstimatedTimeHours()) + UNITS_HOURS;
                }
                case 5: {
                    if (task.getScheduledForDate() != null) {
                        return task.getScheduledForDate().toString();
                    }
                    return "";
                }
            }
        } else if (element instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer taskCategory = (ScheduledTaskContainer)element;
            switch (columnIndex) {
                case 2: {
                    if (taskCategory.isPresent()) {
                        return String.valueOf(taskCategory.getSummary()) + " - Today";
                    }
                    return taskCategory.getSummary();
                }
                case 3: {
                    String elapsedTimeString = NO_MINUTES;
                    try {
                        long elapsed = 0L;
                        Object[] objectArray = this.contentProvider.getChildren((Object)taskCategory);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            AbstractTask task = (AbstractTask)o;
                            elapsed += this.activityManager.getElapsedTime((ITask)task, taskCategory.getStart(), taskCategory.getEnd());
                            ++n2;
                        }
                        elapsedTimeString = DateUtil.getFormattedDurationShort((long)elapsed);
                        if (elapsedTimeString.equals("")) {
                            elapsedTimeString = NO_MINUTES;
                        }
                    }
                    catch (RuntimeException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not format elapsed time", (Throwable)e));
                    }
                    return elapsedTimeString;
                }
                case 4: {
                    long estimated = 0L;
                    Object[] objectArray = this.contentProvider.getChildren((Object)taskCategory);
                    int n = objectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object o = objectArray[n3];
                        if (o instanceof AbstractTask) {
                            estimated += (long)((AbstractTask)o).getEstimatedTimeHours();
                        }
                        ++n3;
                    }
                    return String.valueOf(estimated) + UNITS_HOURS;
                }
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof ITaskContainer && !(element instanceof ITask)) {
            return this.categoryBackgroundColor;
        }
        return super.getBackground(element);
    }

    public Font getFont(Object element) {
        if (element instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer container = (ScheduledTaskContainer)element;
            if (container.isPresent()) {
                return CommonFonts.BOLD;
            }
        } else if (element instanceof ITask) {
            AbstractTask task = (AbstractTask)element;
            return super.getFont((Object)task);
        }
        return super.getFont(element);
    }

    public void setCategoryBackgroundColor(Color categoryBackgroundColor) {
        this.categoryBackgroundColor = categoryBackgroundColor;
    }
}

