/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;

public class TaskActivityViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    protected final TaskActivityManager taskActivityManager;

    public TaskActivityViewContentProvider(TaskActivityManager taskActivityManager) {
        this.taskActivityManager = taskActivityManager;
    }

    public Object[] getElements(Object parent) {
        HashSet<ScheduledTaskContainer> containers = new HashSet<ScheduledTaskContainer>();
        WeekDateRange week = TaskActivityUtil.getCurrentWeek();
        for (DateRange day : week.getDaysOfWeek()) {
            containers.add(new ScheduledTaskContainer(TasksUiPlugin.getTaskActivityManager(), day));
        }
        return containers.toArray();
    }

    public Object getParent(Object child) {
        Object[] objectArray = this.getElements(null);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            ScheduledTaskContainer container = (ScheduledTaskContainer)o;
            Object[] objectArray2 = this.getChildren(container);
            int n3 = objectArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                Object o2 = objectArray2[n4];
                if (o2 instanceof AbstractTask && ((AbstractTask)o2).equals(child)) {
                    return container;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ScheduledTaskContainer) {
            DateRange range = ((ScheduledTaskContainer)parent).getDateRange();
            Set activeTasks = TasksUiPlugin.getTaskActivityManager().getActiveTasks(range.getStartDate(), range.getEndDate());
            return activeTasks.toArray();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        return this.getChildren(parent).length > 0;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

