/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.internal.monitor.usage.Messages;
import org.eclipse.mylyn.internal.monitor.usage.StudyParameters;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorPlugin;
import org.eclipse.mylyn.internal.monitor.usage.wizards.UsageSubmissionWizard;
import org.eclipse.mylyn.internal.monitor.usage.wizards.UsageSubmissionWizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class CheckForUploadJob
extends UIJob {
    public CheckForUploadJob(Display display) {
        super(display, Messages.CheckForUploadJob_Check_For_Upload);
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (this.getDisplay() == null || this.getDisplay().isDisposed() || PlatformUI.getWorkbench().isClosing()) {
            return Status.CANCEL_STATUS;
        }
        if (!MonitorUiPlugin.getDefault().suppressConfigurationWizards() && ContextCorePlugin.getDefault() != null) {
            this.checkForStatisticsUpload();
        }
        return Status.OK_STATUS;
    }

    synchronized void checkForStatisticsUpload() {
        Date currentTime = new Date();
        if (this.shouldAskForUpload(currentTime)) {
            String ending = this.getUserPromptDelay() == 1L ? "" : "s";
            MessageDialog message = new MessageDialog(Display.getDefault().getActiveShell(), Messages.UiUsageMonitorPlugin_Send_Usage_Feedback, null, Messages.UiUsageMonitorPlugin_Help_Improve_Eclipse_And_Mylyn, 3, new String[]{Messages.UiUsageMonitorPlugin_Submit_Feedback, NLS.bind((String)Messages.UiUsageMonitorPlugin_Remind_Me_In_X_Days, (Object)this.getUserPromptDelay(), (Object)ending), Messages.UiUsageMonitorPlugin_Dont_Ask_Again}, 0);
            int result = message.open();
            if (result == 0) {
                UiUsageMonitorPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.upload.previousTransmit", currentTime.getTime());
                if (!UiUsageMonitorPlugin.getDefault().getPreferenceStore().contains("org.eclipse.mylyn.monitor.mylyn.eclipse.org.consent.viewed") || !UiUsageMonitorPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.mylyn.eclipse.org.consent.viewed")) {
                    MessageDialog consentMessage = new MessageDialog(Display.getDefault().getActiveShell(), Messages.UiUsageMonitorPlugin_Consent, null, Messages.UiUsageMonitorPlugin_All_Data_Public, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    consentMessage.open();
                    UiUsageMonitorPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.mylyn.eclipse.org.consent.viewed", true);
                }
                UsageSubmissionWizard wizard = new UsageSubmissionWizard();
                wizard.init(PlatformUI.getWorkbench(), null);
                UsageSubmissionWizardDialog dialog = new UsageSubmissionWizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.create();
                dialog.open();
            } else if (result == 1) {
                UiUsageMonitorPlugin.getDefault().userCancelSubmitFeedback(currentTime, true);
            } else {
                UiUsageMonitorPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.monitor.enable.submission", false);
            }
            message.close();
        }
    }

    private boolean shouldAskForUpload(Date currentTime) {
        if (UiUsageMonitorPlugin.getDefault().isSubmissionWizardOpen()) {
            return false;
        }
        StudyParameters studyParameters = UiUsageMonitorPlugin.getDefault().getStudyParameters();
        if (!UiUsageMonitorPlugin.getDefault().isMonitoringEnabled() || studyParameters == null || !studyParameters.shouldPromptForSubmission()) {
            return false;
        }
        Date lastTransmit = UiUsageMonitorPlugin.getDefault().getLastTransmitDate();
        return currentTime.getTime() > lastTransmit.getTime() + studyParameters.getTransmitPromptPeriod() && UiUsageMonitorPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.enable.submission");
    }

    private long getUserPromptDelay() {
        return 5L;
    }
}

