/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.sandbox.search.ui.DesktopSearchQuery;
import org.eclipse.mylyn.internal.sandbox.search.ui.Messages;
import org.eclipse.mylyn.internal.sandbox.search.ui.SearchCriteriaPersistence;
import org.eclipse.mylyn.internal.sandbox.search.ui.SearchPlugin;
import org.eclipse.mylyn.internal.sandbox.search.ui.SearchProviders;
import org.eclipse.mylyn.sandbox.search.ui.SearchCriteria;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class DesktopSearchPage
extends DialogPage
implements ISearchPage {
    private static final String PAGE_NAME = "DesktopSearch";
    public static final String PAGE_ID = "org.eclipse.mylyn.internal.sandbox.search.ui.desktopSearchPage";
    private static final int MAX_HISTORY = 20;
    private ISearchPageContainer container;
    private Combo searchText;
    private boolean initialized;
    private List<SearchCriteria> searchHistory;
    private Combo filenamePatternText;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(container);
        this.addTextControls(container);
        this.addFileNamePatternControls(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private void addTextControls(Composite container) {
        Label searchLabel = new Label(container, 16384);
        searchLabel.setText(Messages.DesktopSearchPage_TextLabel);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)searchLabel);
        this.searchText = new Combo(container, 2052);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.searchText);
        this.searchText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DesktopSearchPage.this.searchTextSelected();
                DesktopSearchPage.this.updateStatus();
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DesktopSearchPage.this.updateStatus();
            }
        });
    }

    private void addFileNamePatternControls(Composite container) {
        Label searchLabel = new Label(container, 16384);
        searchLabel.setText(Messages.DesktopSearchPage_FilenamePatterns);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)searchLabel);
        this.filenamePatternText = new Combo(container, 2052);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.filenamePatternText);
        this.filenamePatternText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DesktopSearchPage.this.updateStatus();
            }
        });
        this.filenamePatternText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DesktopSearchPage.this.updateStatus();
            }
        });
    }

    private void searchTextSelected() {
        int index = this.searchText.getSelectionIndex();
        if (index >= 0 && index < this.getSearchHistory().size()) {
            SearchCriteria item = this.getSearchHistory().get(index);
            if (!this.searchText.getText().equals(item.getText())) {
                return;
            }
            this.filenamePatternText.setText(item.getFilenamePatternsAsText());
        }
    }

    public boolean performAction() {
        SearchCriteria criteria = this.computeSearchCriteria();
        this.getSearchHistory().remove(criteria);
        this.getSearchHistory().add(0, criteria);
        this.saveSearchHistory();
        try {
            NewSearchUI.runQueryInBackground((ISearchQuery)new DesktopSearchQuery(SearchProviders.getSearchProvider(), criteria));
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.DesktopSearchPage_SearchFailedTitle, (String)NLS.bind((String)Messages.DesktopSearchPage_SearchFailedMessage, (Object)e.getStatus().getMessage()), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    public ISearchPageContainer getContainer() {
        return this.container;
    }

    public void setVisible(boolean visible) {
        if (!this.initialized) {
            this.initialized = true;
            String[] previousSearchItems = this.getPreviousSearchItems();
            this.searchText.setItems(previousSearchItems);
            if (!this.initializeSearchSettings() && !this.getSearchHistory().isEmpty()) {
                this.initializeSearchSettings(this.getSearchHistory().get(0));
            }
            if (this.filenamePatternText.getText().length() == 0) {
                this.filenamePatternText.setText("*");
            }
            this.updateStatus();
        }
        super.setVisible(visible);
    }

    private String[] getPreviousSearchItems() {
        List<SearchCriteria> searchHistory = this.getSearchHistory();
        ArrayList<String> items = new ArrayList<String>();
        for (SearchCriteria item : searchHistory) {
            items.add(item.getText());
        }
        return items.toArray(new String[items.size()]);
    }

    private SearchCriteria computeSearchCriteria() {
        SearchCriteria item = new SearchCriteria();
        item.setText(this.searchText.getText());
        item.setFilenamePatternsAsText(this.filenamePatternText.getText());
        return item;
    }

    private IDialogSettings getDialogSettings() {
        return SearchPlugin.getDefault().getDialogSettings(PAGE_NAME);
    }

    public List<SearchCriteria> getSearchHistory() {
        if (this.searchHistory == null) {
            this.loadSearchHistory();
        }
        return this.searchHistory;
    }

    private void loadSearchHistory() {
        ArrayList<SearchCriteria> newSearchHistory = new ArrayList<SearchCriteria>();
        SearchCriteriaPersistence persistence = new SearchCriteriaPersistence();
        IDialogSettings settings = this.getDialogSettings();
        int x = 0;
        while (x < 20) {
            IDialogSettings historySection = settings.getSection("history" + x);
            if (historySection == null) break;
            SearchCriteria item = new SearchCriteria();
            persistence.load(item, historySection);
            newSearchHistory.add(item);
            ++x;
        }
        this.searchHistory = newSearchHistory;
    }

    private void saveSearchHistory() {
        SearchCriteriaPersistence persistence = new SearchCriteriaPersistence();
        IDialogSettings settings = this.getDialogSettings();
        int x = 0;
        while (x < 20) {
            String itemName = "history" + x;
            IDialogSettings historySection = settings.getSection(itemName);
            if (historySection == null) {
                if (x >= this.searchHistory.size()) break;
                historySection = settings.addNewSection(itemName);
            }
            persistence.save(this.searchHistory.get(x), historySection);
            ++x;
        }
    }

    private void updateStatus() {
        boolean ok = true;
        SearchCriteria item = this.computeSearchCriteria();
        if (item.getText() == null || item.getText().trim().length() == 0) {
            ok = false;
            this.setMessage(Messages.DesktopSearchPage_SpecifyTextPrompt, 3);
        }
        if (ok && item.getFilenamePatterns().length == 0) {
            ok = false;
            this.setMessage(Messages.DesktopSearchPage_SpecifyFilenamePatternsPrompt, 3);
        }
        if (ok) {
            this.setMessage(null);
        }
        this.getContainer().setPerformActionEnabled(ok);
    }

    private boolean initializeSearchSettings() {
        String text;
        ISelection selection = this.getContainer().getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty() && (text = ((ITextSelection)selection).getText()) != null && text.trim().length() > 0) {
            SearchCriteria item = this.computeSearchHistoryItem(text);
            this.initializeSearchSettings(item);
            return true;
        }
        return false;
    }

    private void initializeSearchSettings(SearchCriteria item) {
        this.searchText.setText(item.getText());
        this.filenamePatternText.setText(item.getFilenamePatternsAsText());
    }

    private SearchCriteria computeSearchHistoryItem(String text) {
        SearchCriteria historyItem2;
        for (SearchCriteria historyItem2 : this.getSearchHistory()) {
            if (!historyItem2.getText().equals(text)) continue;
            return historyItem2;
        }
        historyItem2 = new SearchCriteria();
        historyItem2.setText(text);
        historyItem2.setFilenamePatternsAsText("*");
        return historyItem2;
    }
}

