/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.search.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.internal.sandbox.search.ui.Messages;
import org.eclipse.mylyn.sandbox.search.ui.SearchCallback;
import org.eclipse.mylyn.sandbox.search.ui.SearchCriteria;
import org.eclipse.mylyn.sandbox.search.ui.SearchProvider;
import org.eclipse.osgi.util.NLS;

public class CompositeSearchProvider
extends SearchProvider {
    private List<SearchProvider> delegates;

    public CompositeSearchProvider() {
        this(new ArrayList<SearchProvider>());
    }

    public CompositeSearchProvider(List<SearchProvider> searchProviders) {
        this.delegates = searchProviders;
    }

    public List<SearchProvider> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(List<SearchProvider> delegates) {
        this.delegates = delegates;
    }

    @Override
    public void performSearch(SearchCriteria searchSpecification, SearchCallback callback, IProgressMonitor m) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m);
        monitor.beginTask(NLS.bind((String)Messages.CompositeSearchProvider_SearchingTask, (Object)searchSpecification.getText()), 10000 * this.delegates.size());
        try {
            for (SearchProvider provider : this.delegates) {
                provider.performSearch(searchSpecification, callback, (IProgressMonitor)monitor.newChild(10000));
            }
        }
        finally {
            monitor.done();
        }
    }
}

