/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.editors;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.sandbox.ui.hyperlinks.ResourceHyperlinkExtensions;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.ResourceTransfer;

public class TaskEditorDropTarget
extends StyledTextDropTargetEffect {
    public static final String DEFAULT_PREFIX = "file";
    private final SourceViewer editor;

    public static void addDropTargetSupport(SourceViewer editor) {
        new TaskEditorDropTarget(editor);
    }

    private TaskEditorDropTarget(SourceViewer editor) {
        super(editor.getTextWidget());
        this.editor = editor;
        DropTarget target = new DropTarget(editor.getControl(), 1);
        target.setTransfer(new Transfer[]{JavaUI.getJavaElementClipboardTransfer(), ResourceTransfer.getInstance(), TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)this);
    }

    public void dragEnter(DropTargetEvent event) {
        super.dragEnter(event);
        event.detail = 1;
    }

    public void drop(DropTargetEvent event) {
        StringBuilder shouldDropText = new StringBuilder();
        if (TextTransfer.getInstance().isSupportedType(event.currentDataType) && event.data instanceof String) {
            shouldDropText.append((String)event.data);
        } else if (JavaUI.getJavaElementClipboardTransfer().isSupportedType(event.currentDataType) && event.data instanceof IJavaElement[]) {
            Object[] elements;
            Object[] objectArray = elements = (IJavaElement[])event.data;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = objectArray[n2];
                shouldDropText.append(String.valueOf(ResourceHyperlinkExtensions.getGeneratedPrefix("java")) + element.getElementName() + this.addCommaIfNeeded(elements, element));
                ++n2;
            }
        } else if (ResourceTransfer.getInstance().isSupportedType(event.currentDataType) && event.data instanceof IResource[]) {
            Object[] elements;
            Object[] objectArray = elements = (IResource[])event.data;
            int n = elements.length;
            int n3 = 0;
            while (n3 < n) {
                IResource element = objectArray[n3];
                String fullName = element.getName();
                int sep_pos = fullName.lastIndexOf(".");
                if (sep_pos != -1) {
                    String fileName = fullName.substring(0, sep_pos);
                    String fileType = fullName.substring(sep_pos + 1);
                    String generatedPrefix = ResourceHyperlinkExtensions.getGeneratedPrefix(fileType.toLowerCase());
                    if (generatedPrefix != null) {
                        shouldDropText.append(String.valueOf(generatedPrefix) + " " + fileName + this.addCommaIfNeeded(elements, element));
                    } else {
                        shouldDropText.append(String.valueOf(ResourceHyperlinkExtensions.getDefaultPrefix()) + " " + element.getFullPath().toString().substring(1) + this.addCommaIfNeeded(elements, element));
                    }
                }
                ++n3;
            }
        }
        if (shouldDropText.length() > 0) {
            this.dropTextToCurrentPosition(shouldDropText.toString());
        }
    }

    private String addCommaIfNeeded(Object[] elements, Object element) {
        return elements.length > 1 && element != elements[elements.length - 1] ? ", " : "";
    }

    private void dropTextToCurrentPosition(String shouldDropText) {
        try {
            ITextSelection textSelection = (ITextSelection)this.editor.getSelection();
            IDocument currentDocument = this.editor.getDocument();
            currentDocument.replace(textSelection.getOffset(), 0, shouldDropText);
            this.editor.getTextWidget().setFocus();
            this.editor.setSelection((ISelection)new TextSelection(textSelection.getOffset() + shouldDropText.length(), 0));
        }
        catch (BadLocationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not drop text", (Throwable)e));
        }
    }
}

