/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.editors;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

public class EditorStyleContributionItem
extends CompoundContributionItem {
    public EditorStyleContributionItem() {
        this(null);
    }

    public EditorStyleContributionItem(String id) {
        this(id, TasksUiUtil.getSelectedRepository());
    }

    public EditorStyleContributionItem(String id, TaskRepository taskRepository) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        items.add(new ActionContributionItem((IAction)new InteranlLinkAction()));
        return items.toArray(new IContributionItem[items.size()]);
    }

    private static void setInternalLink(String internalLink) {
        TaskRepository taskRepository = TasksUiUtil.getSelectedRepository();
        taskRepository.setProperty("wikiLinkPattern", internalLink);
    }

    private class InteranlLinkAction
    extends Action {
        public InteranlLinkAction() {
            super("Set Internal Link...");
            this.setToolTipText("Set the internal link pattern for choosen markup language");
        }

        public void run() {
            InputDialog dialog;
            String title = "Internal link pattern setting";
            String message = "Set the internal link pattern for choosen markup language,\ne.g. http://wiki.eclipse.org/{0}";
            TaskRepository taskRepository = TasksUiUtil.getSelectedRepository();
            String initialValue = taskRepository.getProperty("wikiLinkPattern");
            if (initialValue == null) {
                initialValue = "";
            }
            if ((dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, message, initialValue, new IInputValidator(){

                public String isValid(String newText) {
                    return newText.indexOf("://") == -1 ? "Enter a valid URL" : null;
                }
            })).open() == 0) {
                EditorStyleContributionItem.setInternalLink(dialog.getValue());
            }
        }
    }
}

