/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.commands;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class ContextCapturePauseHandler
extends AbstractHandler
implements IElementUpdater {
    private final AbstractContextListener CONTEXT_LISTENER = new AbstractContextListener(){

        public void contextActivated(IInteractionContext context) {
            ContextCapturePauseHandler.this.resume();
        }

        public void contextDeactivated(IInteractionContext context) {
            ContextCapturePauseHandler.this.resume();
        }
    };

    public ContextCapturePauseHandler() {
        ContextCore.getContextManager().addListener(this.CONTEXT_LISTENER);
    }

    public void dispose() {
        ContextCore.getContextManager().removeListener(this.CONTEXT_LISTENER);
        super.dispose();
    }

    public Object execute(ExecutionEvent e) throws ExecutionException {
        if (ContextCore.getContextManager().isContextCapturePaused()) {
            this.resume();
        } else {
            this.pause();
        }
        return null;
    }

    public void resume() {
        ContextCore.getContextManager().setContextCapturePaused(false);
        if (TaskListView.getFromActivePerspective() != null) {
            TaskListView.getFromActivePerspective().indicatePaused(false);
        }
        this.refreshCommands();
    }

    public void pause() {
        ContextCore.getContextManager().setContextCapturePaused(true);
        TaskListView.getFromActivePerspective().indicatePaused(true);
        this.refreshCommands();
    }

    private void refreshCommands() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (service != null) {
            service.refreshElements("org.eclipse.mylyn.tasks.ui.command.previousTask", null);
            service.refreshElements("org.eclipse.mylyn.ui.context.capture.pause.command", null);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setChecked(ContextCore.getContextManager().isContextCapturePaused());
    }
}

