/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Characters;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.HtmlEntity;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;

public class HtmlEntitySpan
extends SourceSpan {
    private final Pattern pattern = Pattern.compile("&(#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});.*", 34);

    @Override
    public Optional<? extends Inline> createInline(Cursor cursor) {
        Matcher matcher;
        char c = cursor.getChar();
        if (c == '&' && (matcher = cursor.matcher(this.pattern)).matches()) {
            String ent = matcher.group(1);
            int offset = cursor.getOffset();
            int length = ent.length() + 2;
            Line lineAtOffset = cursor.getLineAtOffset();
            if (this.isInvalidUnicodeCodepoint(ent)) {
                return Optional.of(new Characters(lineAtOffset, offset, length, "\ufffd"));
            }
            return Optional.of(new HtmlEntity(lineAtOffset, offset, length, ent));
        }
        return Optional.empty();
    }

    protected boolean isInvalidUnicodeCodepoint(String ent) {
        if (ent.charAt(0) == '#') {
            try {
                char firstCharFollowingHash = ent.charAt(1);
                int codePoint = firstCharFollowingHash == 'x' || firstCharFollowingHash == 'X' ? Integer.parseInt(ent.substring(2), 16) : Integer.parseInt(ent.substring(1));
                return codePoint <= 0 || codePoint > 65535;
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        return false;
    }
}

