/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContextBuilder;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.parser.IdGenerator;

public class ProcessingContext {
    private final InlineParser inlineParser;
    private final ImmutableMap<String, NamedUriWithTitle> links;
    private final IdGenerator idGenerator;

    public static ProcessingContextBuilder builder() {
        return new ProcessingContextBuilder();
    }

    ProcessingContext(InlineParser inlineParser, ImmutableMap<String, NamedUriWithTitle> links, IdGenerator idGenerator) {
        this.inlineParser = (InlineParser)Preconditions.checkNotNull((Object)inlineParser);
        this.links = (ImmutableMap)Preconditions.checkNotNull(links);
        this.idGenerator = (IdGenerator)Preconditions.checkNotNull((Object)idGenerator);
    }

    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    public NamedUriWithTitle namedUriWithTitle(String name) {
        return (NamedUriWithTitle)this.links.get((Object)name.toLowerCase());
    }

    public String generateHeadingId(int headingLevel, String headingText) {
        return this.idGenerator.newId("h" + headingLevel, headingText);
    }

    public InlineParser getInlineParser() {
        return this.inlineParser;
    }

    public static class NamedUriWithTitle {
        private final String name;
        private final String uri;
        private final String title;

        public NamedUriWithTitle(String name, String uri, String title) {
            this.name = name;
            this.uri = uri;
            this.title = title;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

