/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.HardLineBreak;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SoftLineBreak;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;

public class LineBreakSpan
extends SourceSpan {
    private final Pattern pattern = Pattern.compile("( *(\\\\)?\n).*", 32);

    @Override
    public Optional<? extends Inline> createInline(Cursor cursor) {
        Matcher matcher;
        char c = cursor.getChar();
        if ((c == '\n' || c == ' ') && (matcher = cursor.matcher(this.pattern)).matches()) {
            int length = matcher.group(1).length();
            if (length > 2 || matcher.group(2) != null) {
                return Optional.of((Object)new HardLineBreak(cursor.getLineAtOffset(), cursor.getOffset(), length));
            }
            return Optional.of((Object)new SoftLineBreak(cursor.getLineAtOffset(), cursor.getOffset(), length));
        }
        return Optional.absent();
    }
}

