/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;

public abstract class InlineWithNestedContents
extends Inline {
    private final List<Inline> contents;

    public InlineWithNestedContents(Line line, int offset, int length, List<Inline> contents) {
        super(line, offset, length);
        this.contents = ImmutableList.copyOf(contents);
    }

    public List<Inline> getContents() {
        return this.contents;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getOffset(), this.getLength(), this.getContents());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InlineWithNestedContents other = (InlineWithNestedContents)obj;
        return this.getContents().equals(other.getContents());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("offset", this.getOffset()).add("length", this.getLength()).add("contents", this.getContents()).toString();
    }
}

