/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;

class HtmlEntities {
    private static HtmlEntities instance = new HtmlEntities();
    private final ListMultimap<String, String> nameToNumericEntityReferences = HtmlEntities.readHtmlEntities();
    private final Map<String, String> nameToStringEquivalent = this.createNameToStringEquivalent(this.nameToNumericEntityReferences);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ListMultimap<String, String> readHtmlEntities() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(HtmlDocumentBuilder.class.getResourceAsStream("html-entity-references.txt"), Charsets.UTF_8));){
            String line;
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).trimResults().omitEmptyStrings();
            while ((line = reader.readLine()) != null) {
                List lineItems = splitter.splitToList((CharSequence)line);
                Preconditions.checkState((lineItems.size() > 1 ? 1 : 0) != 0);
                for (int x = 1; x < lineItems.size(); ++x) {
                    builder.put(lineItems.get(0), lineItems.get(x));
                }
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return builder.build();
    }

    public static HtmlEntities instance() {
        return instance;
    }

    private HtmlEntities() {
    }

    public List<String> nameToEntityReferences(String name) {
        return this.nameToNumericEntityReferences.get((Object)name);
    }

    public String nameToStringEquivalent(String name) {
        return this.nameToStringEquivalent.get(name);
    }

    private Map<String, String> createNameToStringEquivalent(ListMultimap<String, String> nameToNumericEntityReferences) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (String name : nameToNumericEntityReferences.keySet()) {
            mapBuilder.put((Object)name, (Object)this.stringEquivalent(nameToNumericEntityReferences.get((Object)name)));
        }
        return mapBuilder.build();
    }

    private String stringEquivalent(List<String> values) {
        return Normalizer.normalize(values.stream().map(s -> this.numericEntityToString((String)s)).collect(Collectors.joining()), Normalizer.Form.NFC);
    }

    private String numericEntityToString(String s) {
        Preconditions.checkArgument((s.charAt(0) == '#' ? 1 : 0) != 0);
        return String.valueOf((char)Integer.parseInt(s.substring(1)));
    }
}

