/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.validation.IssueSeveritiesProvider;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopes;
import org.eclipse.xtext.xbase.scoping.batch.IBatchScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputer;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractRootedReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionArgumentFactory;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionBasedRootTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.IFeatureScopeTracker;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.RootResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ScopeProviderAccess;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentMerger;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.validation.FeatureNameValidator;

public class DefaultReentrantTypeResolver
extends AbstractRootedReentrantTypeResolver {
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private ITypeComputer typeComputer;
    @Inject
    private ScopeProviderAccess scopeProviderAccess;
    @Inject
    private IBatchScopeProvider batchScopeProvider;
    @Inject
    private ExpressionArgumentFactory expressionArgumentFactory;
    @Inject
    private FeatureNameValidator featureNameValidator;
    @Inject
    private IssueSeveritiesProvider issueSeveritiesProvider;
    @Inject(optional=true)
    private XbaseFactory xbaseFactory = XbaseFactory.eINSTANCE;
    @Inject
    private FeatureScopes featureScopes;
    @Inject
    private IFeatureScopeTracker.Provider featureScopeTrackerProvider;
    private EObject root;
    private boolean resolving = false;

    public final void initializeFrom(EObject root) {
        if (this.root != null) {
            throw new IllegalStateException("Cannot reinitialize. Resolver has already a root: " + this.root);
        }
        this.root = root;
    }

    protected final EObject getRoot() {
        return this.root;
    }

    protected boolean isHandled(EObject context) {
        return EcoreUtil.getRootContainer((EObject)context) == this.getRoot();
    }

    protected boolean isHandled(XExpression expression) {
        return EcoreUtil.getRootContainer((EObject)expression) == this.getRoot();
    }

    protected boolean isHandled(JvmIdentifiableElement identifiableElement) {
        return EcoreUtil.getRootContainer((EObject)identifiableElement) == this.getRoot();
    }

    protected IssueSeverities getIssueSeverities() {
        Resource resource = this.root == null ? null : this.root.eResource();
        return this.issueSeveritiesProvider.getIssueSeverities(resource);
    }

    public IResolvedTypes reentrantResolve() {
        if (this.resolving) {
            throw new UnsupportedOperationException("TODO: import a functional handle on the type resolution that delegates to the best available (current, but evolving) result");
        }
        Stopwatches.StoppedTask task = Stopwatches.forTask((String)"DefaultReentrantTypeResolver.resolve");
        try {
            task.start();
            this.resolving = true;
            IResolvedTypes iResolvedTypes = this.resolve();
            return iResolvedTypes;
        }
        finally {
            this.resolving = false;
            task.stop();
        }
    }

    protected IResolvedTypes resolve() {
        if (this.isInvalidRoot()) {
            return IResolvedTypes.NULL;
        }
        RootResolvedTypes result = this.createResolvedTypes();
        IFeatureScopeSession session = this.batchScopeProvider.newSession(this.root.eResource());
        this.computeTypes(result, session);
        result.resolveUnboundTypeParameters();
        result.resolveProxies();
        result.addDiagnostics(this.root.eResource());
        return result;
    }

    private boolean isInvalidRoot() {
        return this.root == null || this.root.eResource() == null || this.root.eResource().getResourceSet() == null;
    }

    protected RootResolvedTypes createResolvedTypes() {
        return new RootResolvedTypes(this);
    }

    protected IFeatureScopeTracker createFeatureScopeTracker() {
        return this.featureScopeTrackerProvider.track(this.root);
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
        this.computeTypes(resolvedTypes, session, this.root);
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session, EObject element) {
        if (!(element instanceof XExpression)) {
            throw new IllegalArgumentException("element: " + element);
        }
        this._computeTypes(resolvedTypes, session, (XExpression)element);
    }

    protected void _computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session, XExpression expression) {
        ExpressionBasedRootTypeComputationState state = new ExpressionBasedRootTypeComputationState(resolvedTypes, session, expression);
        state.computeTypes();
    }

    protected String getInvalidWritableVariableAccessMessage(XVariableDeclaration variable, XAbstractFeatureCall featureCall) {
        XClosure containingClosure = (XClosure)EcoreUtil2.getContainerOfType((EObject)featureCall, XClosure.class);
        if (containingClosure != null && !EcoreUtil.isAncestor((EObject)containingClosure, (EObject)variable)) {
            return String.format("Cannot refer to the non-final variable %s inside a lambda expression", variable.getSimpleName());
        }
        return null;
    }

    protected boolean isShadowingAllowed(QualifiedName name) {
        return this.featureNameValidator.isShadowingAllowed(name);
    }

    protected boolean isDisallowedName(QualifiedName name) {
        return this.featureNameValidator.isDisallowedName(name);
    }

    protected boolean isDiscouragedName(QualifiedName name) {
        return this.featureNameValidator.isDiscouragedName(name);
    }

    protected ITypeComputer getTypeComputer() {
        return this.typeComputer;
    }

    protected void setTypeComputer(ITypeComputer typeComputer) {
        this.typeComputer = typeComputer;
    }

    protected ScopeProviderAccess getScopeProviderAccess() {
        return this.scopeProviderAccess;
    }

    protected IBatchScopeProvider getBatchScopeProvider() {
        return this.batchScopeProvider;
    }

    protected ExpressionArgumentFactory getExpressionArgumentFactory() {
        return this.expressionArgumentFactory;
    }

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected BoundTypeArgumentMerger getTypeArgumentMerger() {
        return this.services.getBoundTypeArgumentMerger();
    }

    protected EObject getSourceElement(EObject element) {
        return element;
    }

    protected XbaseFactory getXbaseFactory() {
        return this.xbaseFactory;
    }

    protected FeatureScopes getFeatureScopes() {
        return this.featureScopes;
    }
}

