/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.OwnedConverter;

public class ExtensionScopeHelper {
    private LightweightTypeReference argumentType;

    public ExtensionScopeHelper(LightweightTypeReference argumentType) {
        this.argumentType = argumentType;
    }

    boolean isPossibleExtension(JvmFeature feature) {
        if (!(feature instanceof JvmOperation)) {
            return false;
        }
        EList parameters = ((JvmExecutable)feature).getParameters();
        return !parameters.isEmpty();
    }

    protected boolean isMatchingFirstParameter(JvmOperation feature) {
        EList parameters = feature.getParameters();
        JvmFormalParameter firstParameter = (JvmFormalParameter)parameters.get(0);
        JvmTypeReference type = firstParameter.getParameterType();
        if (type == null) {
            return false;
        }
        JvmType rawParameterType = type.getType();
        if (rawParameterType == null || rawParameterType.eIsProxy()) {
            return false;
        }
        if (!(rawParameterType instanceof JvmTypeParameter)) {
            LightweightTypeReference rawReceiverType = this.argumentType.getRawTypeReference();
            if (rawReceiverType.isResolved()) {
                LightweightTypeReference parameterTypeReference = new OwnedConverter(rawReceiverType.getOwner()).toRawLightweightReference(rawParameterType);
                if (parameterTypeReference.isResolved() && !parameterTypeReference.isAssignableFrom(rawReceiverType)) {
                    return false;
                }
                if (parameterTypeReference.isArray() && !rawReceiverType.isArray() && !rawReceiverType.isSubtypeOf(Iterable.class)) {
                    return false;
                }
            } else if (this.isArrayTypeMismatch(rawReceiverType, rawParameterType)) {
                return false;
            }
        }
        return true;
    }

    private boolean isArrayTypeMismatch(LightweightTypeReference rawReceiverType, JvmType rawParameterType) {
        LightweightTypeReference parameterTypeReference;
        return rawReceiverType.isArray() && (parameterTypeReference = new OwnedConverter(rawReceiverType.getOwner()).toRawLightweightReference(rawParameterType)).getSuperType(Iterable.class) == null && this.isArrayTypeMismatch(rawReceiverType, parameterTypeReference);
    }

    private boolean isArrayTypeMismatch(LightweightTypeReference receiverType, LightweightTypeReference parameterType) {
        if (receiverType.isArray()) {
            if (parameterType.isArray()) {
                LightweightTypeReference componentType = parameterType.getComponentType();
                return this.isArrayTypeMismatch(receiverType.getComponentType(), componentType);
            }
            return true;
        }
        return !parameterType.isArray() && parameterType.isPrimitive();
    }
}

