/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.interpreter;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.ConstantOperators;
import org.eclipse.xtext.xbase.interpreter.Context;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class AbstractConstantExpressionsInterpreter {
    @Inject
    private ConstantOperators constantOperators;

    protected Object _internalEvaluate(XExpression expression, Context ctx) {
        throw this.notConstantExpression(expression);
    }

    public ConstantExpressionEvaluationException notConstantExpression(XExpression expression) {
        String _text = null;
        if (expression != null) {
            _text = this.toText(expression);
        }
        String _plus = "Not a constant expression : '" + _text;
        String _plus_1 = String.valueOf(_plus) + "'";
        return new ConstantExpressionEvaluationException(_plus_1, expression);
    }

    protected Object _internalEvaluate(XCastedExpression expression, Context ctx) {
        XExpression _target = expression.getTarget();
        return this.internalEvaluate(_target, ctx);
    }

    protected Object _internalEvaluate(XStringLiteral it, Context ctx) {
        return it.getValue();
    }

    protected Object _internalEvaluate(XBooleanLiteral it, Context ctx) {
        return it.isIsTrue();
    }

    protected Object _internalEvaluate(XAnnotation literal, Context ctx) {
        return literal;
    }

    protected Object _internalEvaluate(XTypeLiteral it, Context ctx) {
        JvmType _type = it.getType();
        EList<String> _arrayDimensions = it.getArrayDimensions();
        int _size = _arrayDimensions.size();
        return this.toTypeReference(_type, _size);
    }

    protected JvmTypeReference toTypeReference(final JvmType type, int arrayDimensions) {
        boolean _equals = Objects.equal((Object)type, null);
        if (_equals) {
            return null;
        }
        JvmParameterizedTypeReference _createJvmParameterizedTypeReference = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        Procedures.Procedure1<JvmParameterizedTypeReference> _function = new Procedures.Procedure1<JvmParameterizedTypeReference>(){

            public void apply(JvmParameterizedTypeReference it) {
                it.setType(type);
            }
        };
        JvmTypeReference resultTypeRef = (JvmTypeReference)ObjectExtensions.operator_doubleArrow((Object)_createJvmParameterizedTypeReference, (Procedures.Procedure1)_function);
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, arrayDimensions, true);
        for (Integer i : _doubleDotLessThan) {
            JvmGenericArrayTypeReference arrayRef = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
            arrayRef.setComponentType(resultTypeRef);
            resultTypeRef = arrayRef;
        }
        return resultTypeRef;
    }

    protected Object _internalEvaluate(XBinaryOperation it, Context ctx) {
        Object _xblockexpression = null;
        Context _xifexpression = null;
        boolean _equals = Objects.equal((Object)ctx, null);
        _xifexpression = _equals ? null : ctx.cloneWithExpectation(null);
        Context context = _xifexpression;
        XExpression _leftOperand = it.getLeftOperand();
        Object left = this.internalEvaluate(_leftOperand, context);
        XExpression _rightOperand = it.getRightOperand();
        Object right = this.internalEvaluate(_rightOperand, context);
        String op = it.getConcreteSyntaxFeatureName();
        Object _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)op, (Object)"+")) {
            _matched = true;
            _switchResult = this.constantOperators.plus(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"-")) {
            _matched = true;
            _switchResult = this.constantOperators.minus(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"*")) {
            _matched = true;
            _switchResult = this.constantOperators.multiply(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"/")) {
            _matched = true;
            _switchResult = this.constantOperators.divide(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"%")) {
            _matched = true;
            _switchResult = this.constantOperators.modulo(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"<")) {
            _matched = true;
            _switchResult = this.constantOperators.lessThan(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)">")) {
            _matched = true;
            _switchResult = this.constantOperators.greaterThan(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)"<=")) {
            _matched = true;
            _switchResult = this.constantOperators.lessEquals(left, right);
        }
        if (!_matched && Objects.equal((Object)op, (Object)">=")) {
            _matched = true;
            _switchResult = this.constantOperators.greaterEquals(left, right);
        }
        if (!_matched) {
            if (Objects.equal((Object)op, (Object)"==")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"===")) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = this.constantOperators.same(left, right);
            }
        }
        if (!_matched) {
            if (Objects.equal((Object)op, (Object)"!=")) {
                _matched = true;
            }
            if (!_matched && Objects.equal((Object)op, (Object)"!==")) {
                _matched = true;
            }
            if (_matched) {
                _switchResult = this.constantOperators.notSame(left, right);
            }
        }
        if (!_matched) {
            throw new ConstantExpressionEvaluationException("Couldn't evaluate binary operator '" + op + "' on values " + left + " and " + right);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected Object _internalEvaluate(XUnaryOperation it, Context ctx) {
        Object _xblockexpression = null;
        XExpression _operand = it.getOperand();
        Object value = this.internalEvaluate(_operand, ctx);
        String op = it.getConcreteSyntaxFeatureName();
        Object _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)op, (Object)"-")) {
            _matched = true;
            _switchResult = this.constantOperators.minus(value);
        }
        if (!_matched) {
            boolean _and = false;
            boolean _equals = Objects.equal((Object)op, (Object)"!");
            _and = !_equals ? false : value instanceof Boolean;
            if (_and) {
                _matched = true;
                _switchResult = (Boolean)value == false;
            }
        }
        if (!_matched) {
            boolean _and_1 = false;
            boolean _equals_1 = Objects.equal((Object)op, (Object)"+");
            _and_1 = !_equals_1 ? false : value instanceof Number;
            if (_and_1) {
                _matched = true;
                _switchResult = value;
            }
        }
        if (!_matched) {
            throw new ConstantExpressionEvaluationException("Couldn't evaluate unary operator '" + value + "' on value " + value);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    protected String toText(XExpression expression) {
        ICompositeNode _node = NodeModelUtils.getNode((EObject)expression);
        return _node.getText();
    }

    public Object internalEvaluate(XExpression it, Context ctx) {
        if (it instanceof XBinaryOperation) {
            return this._internalEvaluate((XBinaryOperation)it, ctx);
        }
        if (it instanceof XUnaryOperation) {
            return this._internalEvaluate((XUnaryOperation)it, ctx);
        }
        if (it instanceof XBooleanLiteral) {
            return this._internalEvaluate((XBooleanLiteral)it, ctx);
        }
        if (it instanceof XCastedExpression) {
            return this._internalEvaluate((XCastedExpression)it, ctx);
        }
        if (it instanceof XStringLiteral) {
            return this._internalEvaluate((XStringLiteral)it, ctx);
        }
        if (it instanceof XTypeLiteral) {
            return this._internalEvaluate((XTypeLiteral)it, ctx);
        }
        if (it instanceof XAnnotation) {
            return this._internalEvaluate((XAnnotation)it, ctx);
        }
        if (it != null) {
            return this._internalEvaluate(it, ctx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, ctx).toString());
    }
}

