/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.builder.DerivedResourceMarkers;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.preferences.BuilderPreferenceAccess;
import org.eclipse.xtext.generator.IDerivedResourceMarkers;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.util.ResourceUtil;
import org.eclipse.xtext.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderParticipant
implements IXtextBuilderParticipant {
    private static final Logger logger = Logger.getLogger(BuilderParticipant.class);
    @Inject
    private Provider<EclipseResourceFileSystemAccess2> fileSystemAccessProvider;
    @Inject
    private IGenerator generator;
    @Inject
    private IResourceServiceProvider resourceServiceProvider;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private IDerivedResourceMarkers derivedResourceMarkers;
    @Inject
    private DerivedResourceMarkers.GeneratorIdProvider generatorIdProvider;
    private EclipseOutputConfigurationProvider outputConfigurationProvider;
    private BuilderPreferenceAccess builderPreferenceAccess;

    protected IDerivedResourceMarkers getDerivedResourceMarkers() {
        return this.derivedResourceMarkers;
    }

    protected DerivedResourceMarkers.GeneratorIdProvider getGeneratorIdProvider() {
        return this.generatorIdProvider;
    }

    public BuilderPreferenceAccess getBuilderPreferenceAccess() {
        return this.builderPreferenceAccess;
    }

    @Inject
    public void setBuilderPreferenceAccess(BuilderPreferenceAccess builderPreferenceAccess) {
        this.builderPreferenceAccess = builderPreferenceAccess;
    }

    public EclipseOutputConfigurationProvider getOutputConfigurationProvider() {
        return this.outputConfigurationProvider;
    }

    public IGenerator getGenerator() {
        return this.generator;
    }

    public IResourceServiceProvider getResourceServiceProvider() {
        return this.resourceServiceProvider;
    }

    @Inject
    public void setOutputConfigurationProvider(EclipseOutputConfigurationProvider outputConfigurationProvider) {
        this.outputConfigurationProvider = outputConfigurationProvider;
    }

    protected Map<OutputConfiguration, Iterable<IMarker>> getGeneratorMarkers(IProject builtProject, Collection<OutputConfiguration> outputConfigurations) throws CoreException {
        HashMap generatorMarkers = Maps.newHashMap();
        for (OutputConfiguration config : outputConfigurations) {
            if (!config.isCleanUpDerivedResources()) continue;
            ArrayList markers = Lists.newArrayList();
            for (IContainer container : this.getOutputs(builtProject, config)) {
                Iterables.addAll((Collection)markers, (Iterable)this.derivedResourceMarkers.findDerivedResourceMarkers((IResource)container, this.generatorIdProvider.getGeneratorIdentifier()));
            }
            generatorMarkers.put(config, markers);
        }
        return generatorMarkers;
    }

    @Override
    public void build(final IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        if (!this.isEnabled(context)) {
            return;
        }
        List<IResourceDescription.Delta> deltas = this.getRelevantDeltas(context);
        if (deltas.isEmpty()) {
            return;
        }
        int numberOfDeltas = deltas.size();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(numberOfDeltas + 3));
        EclipseResourceFileSystemAccess2 access = (EclipseResourceFileSystemAccess2)((Object)this.fileSystemAccessProvider.get());
        IProject builtProject = context.getBuiltProject();
        access.setProject(builtProject);
        Map<String, OutputConfiguration> outputConfigurations = this.getOutputConfigurations(context);
        this.refreshOutputFolders(context, outputConfigurations, (IProgressMonitor)subMonitor.newChild(1));
        access.setOutputConfigurations(outputConfigurations);
        if (context.getBuildType() == IXtextBuilderParticipant.BuildType.CLEAN || context.getBuildType() == IXtextBuilderParticipant.BuildType.RECOVERY) {
            SubMonitor cleanMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)outputConfigurations.size());
            for (OutputConfiguration config : outputConfigurations.values()) {
                this.cleanOutput(context, config, access, (IProgressMonitor)cleanMonitor.newChild(1));
            }
            if (context.getBuildType() == IXtextBuilderParticipant.BuildType.CLEAN) {
                return;
            }
        }
        Map<OutputConfiguration, Iterable<IMarker>> generatorMarkers = this.getGeneratorMarkers(builtProject, outputConfigurations.values());
        int i = 0;
        while (i < numberOfDeltas) {
            IResourceDescription.Delta delta = deltas.get(i);
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            subMonitor.subTask("Compiling " + delta.getUri().lastSegment() + " (" + i + " of " + numberOfDeltas + ")");
            access.setMonitor((IProgressMonitor)subMonitor.newChild(1));
            final String uri = delta.getUri().toString();
            final LinkedHashSet derivedResources = Sets.newLinkedHashSet();
            for (OutputConfiguration config : outputConfigurations.values()) {
                if (!config.isCleanUpDerivedResources()) continue;
                Iterable<IMarker> markers = generatorMarkers.get(config);
                for (IMarker marker : markers) {
                    String source = this.derivedResourceMarkers.getSource(marker);
                    if (source == null || !source.equals(uri)) continue;
                    derivedResources.add((IFile)marker.getResource());
                }
            }
            access.setPostProcessor(new EclipseResourceFileSystemAccess2.IFileCallback(){

                public boolean beforeFileDeletion(IFile file) {
                    derivedResources.remove(file);
                    context.needRebuild();
                    return true;
                }

                public void afterFileUpdate(IFile file) {
                    this.handleFileAccess(file);
                }

                public void afterFileCreation(IFile file) {
                    this.handleFileAccess(file);
                }

                protected void handleFileAccess(IFile file) {
                    try {
                        derivedResources.remove(file);
                        BuilderParticipant.this.derivedResourceMarkers.installMarker(file, uri);
                        context.needRebuild();
                    }
                    catch (CoreException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            if (delta.getNew() != null) {
                try {
                    this.handleChangedContents(delta, context, access);
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error((Object)("Error during compilation of '" + delta.getUri() + "'."), (Throwable)e);
                }
            }
            access.flushSourceTraces();
            SubMonitor deleteMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)derivedResources.size());
            for (IFile iFile : Sets.newLinkedHashSet((Iterable)derivedResources)) {
                IMarker marker;
                marker = this.derivedResourceMarkers.findDerivedResourceMarker(iFile, uri);
                if (marker != null) {
                    marker.delete();
                }
                if (this.derivedResourceMarkers.findDerivedResourceMarkers((IResource)iFile).length != 0) continue;
                access.deleteFile(iFile, (IProgressMonitor)deleteMonitor);
                context.needRebuild();
            }
            ++i;
        }
    }

    protected boolean isEnabled(IXtextBuilderParticipant.IBuildContext context) {
        return this.builderPreferenceAccess.isAutoBuildEnabled(context.getBuiltProject());
    }

    protected List<IResourceDescription.Delta> getRelevantDeltas(IXtextBuilderParticipant.IBuildContext context) {
        ArrayList result = Lists.newArrayList();
        for (IResourceDescription.Delta delta : context.getDeltas()) {
            if (!this.resourceServiceProvider.canHandle(delta.getUri())) continue;
            result.add(delta);
        }
        return result;
    }

    protected void refreshOutputFolders(IXtextBuilderParticipant.IBuildContext ctx, Map<String, OutputConfiguration> outputConfigurations, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)outputConfigurations.size());
        for (OutputConfiguration config : outputConfigurations.values()) {
            SubMonitor child = subMonitor.newChild(1);
            IProject project = ctx.getBuiltProject();
            for (IContainer container : this.getOutputs(project, config)) {
                container.refreshLocal(2, (IProgressMonitor)child);
            }
        }
    }

    protected void cleanOutput(IXtextBuilderParticipant.IBuildContext ctx, OutputConfiguration config, IProgressMonitor monitor) throws CoreException {
        this.cleanOutput(ctx, config, null, monitor);
    }

    protected void cleanOutput(IXtextBuilderParticipant.IBuildContext ctx, OutputConfiguration config, EclipseResourceFileSystemAccess2 access, IProgressMonitor monitor) throws CoreException {
        IProject project = ctx.getBuiltProject();
        for (IContainer container : this.getOutputs(project, config)) {
            if (!container.exists()) {
                return;
            }
            if (config.isCanClearOutputDirectory()) {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (!config.isKeepLocalHistory().booleanValue()) {
                        resource.delete(0, monitor);
                    } else if (access == null) {
                        resource.delete(2, monitor);
                    } else {
                        this.delete(resource, config, access, monitor);
                    }
                    ++n2;
                }
                continue;
            }
            if (!config.isCleanUpDerivedResources()) continue;
            List resources = this.derivedResourceMarkers.findDerivedResources(container, null);
            for (IFile iFile : resources) {
                if (access != null) {
                    access.deleteFile(iFile, config.getName(), monitor);
                    continue;
                }
                iFile.delete(config.isKeepLocalHistory() != false ? 2 : 0, monitor);
            }
        }
    }

    private void delete(IResource resource, OutputConfiguration config, EclipseResourceFileSystemAccess2 access, IProgressMonitor monitor) throws CoreException {
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                this.delete(child, config, access, monitor);
                ++n2;
            }
            container.delete(2, monitor);
        } else if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            access.deleteFile(file, config.getName(), monitor);
        } else {
            resource.delete(2, monitor);
        }
    }

    protected void handleChangedContents(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, EclipseResourceFileSystemAccess2 fileSystemAccess) throws CoreException {
        Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
        if (this.shouldGenerate(resource, context)) {
            try {
                this.registerCurrentSourceFolder(context, delta, fileSystemAccess);
                this.generator.doGenerate(resource, (IFileSystemAccess)fileSystemAccess);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                throw e;
            }
        }
    }

    protected void registerCurrentSourceFolder(IXtextBuilderParticipant.IBuildContext context, IResourceDescription.Delta delta, EclipseResourceFileSystemAccess2 fileSystemAccess) {
        Iterable storages = this.storage2UriMapper.getStorages(delta.getUri());
        for (Pair pair : storages) {
            IResource resource = (IResource)pair.getFirst();
            IProject project = (IProject)pair.getSecond();
            for (OutputConfiguration output : this.getOutputConfigurations(context).values()) {
                for (OutputConfiguration.SourceMapping sourceMapping : output.getSourceMappings()) {
                    IContainer folder = ResourceUtil.getContainer((IProject)project, (String)sourceMapping.getSourceFolder());
                    if (!folder.contains((ISchedulingRule)resource)) continue;
                    fileSystemAccess.setCurrentSource(sourceMapping.getSourceFolder());
                    return;
                }
            }
        }
    }

    protected boolean shouldGenerate(Resource resource, IXtextBuilderParticipant.IBuildContext context) {
        try {
            Iterable storages = this.storage2UriMapper.getStorages(resource.getURI());
            for (Pair pair : storages) {
                if (!(pair.getFirst() instanceof IFile) || !((IProject)pair.getSecond()).equals((Object)context.getBuiltProject())) continue;
                IFile file = (IFile)pair.getFirst();
                return file.findMaxProblemSeverity(null, true, 2) != 2;
            }
            return false;
        }
        catch (CoreException exc) {
            throw new WrappedException((Exception)((Object)exc));
        }
    }

    protected Map<String, OutputConfiguration> getOutputConfigurations(IXtextBuilderParticipant.IBuildContext context) {
        Set<OutputConfiguration> configurations = this.outputConfigurationProvider.getOutputConfigurations(context.getBuiltProject());
        return Maps.uniqueIndex(configurations, (Function)new Function<OutputConfiguration, String>(){

            public String apply(OutputConfiguration from) {
                return from.getName();
            }
        });
    }

    protected Set<IContainer> getOutputs(IProject project, OutputConfiguration outputConfiguration) {
        LinkedHashSet outputs = Sets.newLinkedHashSet();
        for (String outputPath : outputConfiguration.getOutputDirectories()) {
            IContainer output = ResourceUtil.getContainer((IProject)project, (String)outputPath);
            outputs.add(output);
        }
        return outputs;
    }
}

